/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.BaseVerificationPhase;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.ReplayPhase;
import mockit.internal.expectations.VerifiedExpectation;
import mockit.internal.expectations.invocation.ExpectedInvocation;

final class OrderedVerificationPhase
extends BaseVerificationPhase {
    @Nonnegative
    private final int expectationCount;
    @Nonnegative
    private int indexIncrement;

    OrderedVerificationPhase(@Nonnull ReplayPhase replayPhase) {
        super(replayPhase);
        this.discardExpectationsAndArgumentsAlreadyVerified(replayPhase.invocations);
        this.expectationCount = replayPhase.invocations.size();
        this.indexIncrement = 1;
    }

    private void discardExpectationsAndArgumentsAlreadyVerified(List<Expectation> expectationsInReplayOrder) {
        for (VerifiedExpectation verified : this.executionState.verifiedExpectations) {
            int i = expectationsInReplayOrder.indexOf(verified.expectation);
            if (i < 0) continue;
            expectationsInReplayOrder.set(i, null);
        }
    }

    @Override
    @Nonnull
    List<ExpectedInvocation> findExpectation(@Nullable Object mock, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nonnull Object[] args) {
        Expectation expectation = this.currentVerification;
        int i = this.replayIndex;
        while (i >= 0 && i < this.expectationCount) {
            Expectation replayExpectation = this.replayPhase.invocations.get(i);
            Object replayInstance = this.replayPhase.invocationInstances.get(i);
            Object[] replayArgs = this.replayPhase.invocationArguments.get(i);
            i += this.indexIncrement;
            if (replayExpectation == null) continue;
            if (!this.matchInstance && this.executionState.isToBeMatchedOnInstance(mock, mockNameAndDesc)) {
                this.matchInstance = true;
            }
            if (!this.matches(mock, mockClassDesc, mockNameAndDesc, args, replayExpectation, replayInstance, replayArgs)) continue;
            this.currentExpectation = replayExpectation;
            this.indexIncrement = 1;
            this.replayIndex = i += 1 - this.indexIncrement;
            if (expectation == null) break;
            ++expectation.constraints.invocationCount;
            break;
        }
        return Collections.emptyList();
    }

    @Override
    void addVerifiedExpectation(@Nonnull Expectation expectation, @Nonnull Object[] args) {
        VerifiedExpectation verifiedExpectation = new VerifiedExpectation(expectation, args, this.argMatchers, this.replayIndex);
        this.addVerifiedExpectation(verifiedExpectation);
    }

    @Override
    void handleInvocationCountConstraint(int minInvocations, int maxInvocations) {
        Error errorThrown = this.pendingError;
        this.pendingError = null;
        if (errorThrown != null && minInvocations > 0) {
            throw errorThrown;
        }
        Expectation verifying = this.currentVerification;
        if (verifying == null) {
            return;
        }
        ExpectedInvocation invocation = verifying.invocation;
        this.argMatchers = invocation.arguments.getMatchers();
        int invocationCount = 1;
        while (this.replayIndex < this.expectationCount) {
            Expectation replayExpectation = this.replayPhase.invocations.get(this.replayIndex);
            if (replayExpectation != null && this.matchesCurrentVerification(invocation, replayExpectation)) {
                ++verifying.constraints.invocationCount;
                if (++invocationCount > maxInvocations) {
                    if (maxInvocations < 0) break;
                    throw replayExpectation.invocation.errorForUnexpectedInvocation();
                }
            } else if (invocationCount >= minInvocations) break;
            ++this.replayIndex;
        }
        this.argMatchers = null;
        int n = minInvocations - invocationCount;
        if (n > 0) {
            throw invocation.errorForMissingInvocations(n, Collections.emptyList());
        }
        this.verifyMaxInvocations(verifying, maxInvocations);
    }

    private boolean matchesCurrentVerification(@Nonnull ExpectedInvocation invocation, @Nonnull Expectation replayExpectation) {
        Object mock = invocation.instance;
        String mockClassDesc = invocation.getClassDesc();
        String mockNameAndDesc = invocation.getMethodNameAndDescription();
        Object[] args = invocation.arguments.getValues();
        this.matchInstance = invocation.matchInstance;
        if (this.executionState.isToBeMatchedOnInstance(mock, mockNameAndDesc)) {
            this.matchInstance = true;
        }
        Object replayInstance = this.replayPhase.invocationInstances.get(this.replayIndex);
        Object[] replayArgs = this.replayPhase.invocationArguments.get(this.replayIndex);
        return this.matches(mock, mockClassDesc, mockNameAndDesc, args, replayExpectation, replayInstance, replayArgs);
    }

    private void verifyMaxInvocations(@Nonnull Expectation verifying, int maxInvocations) {
        int n;
        if (maxInvocations >= 0 && (n = verifying.constraints.invocationCount - maxInvocations) > 0) {
            Object[] replayArgs = this.replayPhase.invocationArguments.get(this.replayIndex - 1);
            throw verifying.invocation.errorForUnexpectedInvocations(replayArgs, n);
        }
    }
}

