/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.reflection;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.util.Utilities;

public final class FieldReflection {
    private FieldReflection() {
    }

    @Nullable
    public static <T> T getFieldValue(@Nonnull Field field, @Nullable Object targetObject) {
        Utilities.ensureThatMemberIsAccessible(field);
        try {
            if (targetObject != null && !field.getDeclaringClass().isInstance(targetObject)) {
                Field outerInstanceField = targetObject.getClass().getDeclaredField("this$0");
                targetObject = FieldReflection.getFieldValue(outerInstanceField, targetObject);
            }
            return (T)field.get(targetObject);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValue(@Nonnull Field field, @Nullable Object targetObject, @Nullable Object value) {
        Utilities.ensureThatMemberIsAccessible(field);
        try {
            if (targetObject != null && !field.getDeclaringClass().isInstance(targetObject)) {
                Field outerInstanceField = targetObject.getClass().getDeclaredField("this$0");
                targetObject = FieldReflection.getFieldValue(outerInstanceField, targetObject);
            }
            field.set(targetObject, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

