/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.filesystem;

import fi.kanta.arkistopalvelu.olddocuments.exception.ErrorWrapperLoader;
import fi.kanta.arkistopalvelu.olddocuments.filesystem.ManifestBean;
import fi.kanta.arkistopalvelu.olddocuments.filesystem.ManifestHandler;
import fi.kanta.arkistopalvelu.olddocuments.logging.DbLogger;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ManifestReader {
    private String filename = "";
    private String directory = "";
    private String logId;
    Logger log4j = Logger.getLogger(ManifestReader.class);
    private LogHelper logHelper = new LogHelper();
    private ErrorWrapperLoader errorWrapper;
    private ManifestBean manifestBean;
    private static Logger ERRORLOGGER = Logger.getLogger((String)"errorlog");

    public ManifestReader(String filename, String directory) throws PropertyException {
        this.logId = PropertyHandler.getInstance().getProperty(null, "logId");
        this.filename = filename;
        this.directory = directory;
        this.errorWrapper = ErrorWrapperLoader.getInstance();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDataPath() {
        return this.directory;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Deprecated
    public void setDataPath(String dataPath) {
        this.directory = dataPath;
    }

    private boolean dovalidate() {
        try {
            return Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(null, "validatekoontitiedosto"));
        }
        catch (PropertyException e) {
            System.err.println("Failed to read property 'validatekoontitiedosto', exiting..");
            System.exit(1);
            return false;
        }
    }

    public void readManifest() throws UtilException {
        DbLogger logger = new DbLogger();
        String absolutePath = this.directory + File.separatorChar + this.filename;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            if (this.dovalidate()) {
                factory.setValidating(true);
                factory.setNamespaceAware(true);
                factory.setSchema(PropertyHandler.getInstance().getKoontiedostoSchema());
                factory.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            SAXParser saxParser = factory.newSAXParser();
            ManifestHandler handler = new ManifestHandler(this.directory, absolutePath);
            saxParser.parse(absolutePath, (DefaultHandler)handler);
            this.manifestBean = handler.getManifestBean();
            logger.poistaVirheManifest(absolutePath);
        }
        catch (IOException | ParserConfigurationException e) {
            InternalServiceError error = this.errorWrapper.getError("0017");
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, error));
            this.log4j.error((Object)(this.directory + File.separatorChar + this.filename));
            ERRORLOGGER.error((Object)("koontitiedoston k\u00e4sittely ep\u00e4onnistui: " + absolutePath), (Throwable)e);
            logger.kirjaaKoontitiedostovirhe(absolutePath);
            throw new UtilException(error);
        }
        catch (SAXException e) {
            InternalServiceError error = this.errorWrapper.getError("0017");
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, error));
            this.log4j.error((Object)("xml parsinta ep\u00e4onnistui: " + this.directory + File.separatorChar + this.filename));
            ERRORLOGGER.error((Object)("koontitiedoston k\u00e4sittely ep\u00e4onnistui: " + absolutePath), (Throwable)e);
            logger.kirjaaKoontitiedostovirhe(absolutePath);
            throw new UtilException(error);
        }
    }

    @Deprecated
    public void readManifestOld() throws UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        DbLogger logger = new DbLogger();
        String absolutePath = this.directory + File.separatorChar + this.filename;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(absolutePath));
            logger.poistaVirheManifest(absolutePath);
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)this.logHelper.formatMsgEnd(this.logId));
            }
        }
        catch (IOException | ParserConfigurationException e) {
            InternalServiceError error = this.errorWrapper.getError("0017");
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, error));
            this.log4j.error((Object)(this.directory + File.separatorChar + this.filename));
            ERRORLOGGER.error((Object)("koontitiedoston k\u00e4sittely ep\u00e4onnistui: " + absolutePath), (Throwable)e);
            logger.kirjaaKoontitiedostovirhe(absolutePath);
            throw new UtilException(error);
        }
        catch (SAXException e) {
            InternalServiceError error = this.errorWrapper.getError("0017");
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, error));
            this.log4j.error((Object)("xml parsinta ep\u00e4onnistui: " + this.directory + File.separatorChar + this.filename));
            ERRORLOGGER.error((Object)("koontitiedoston k\u00e4sittely ep\u00e4onnistui: " + absolutePath), (Throwable)e);
            logger.kirjaaKoontitiedostovirhe(absolutePath);
            throw new UtilException(error);
        }
    }

    public ManifestBean getManifest() {
        return this.manifestBean;
    }
}

