/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.manifest;

import fi.kanta.arkistopalvelu.olddocuments.filesystem.ManifestBean;
import fi.kanta.arkistopalvelu.olddocuments.filesystem.ManifestReader;
import fi.kanta.arkistopalvelu.olddocuments.metadata.Palvelutapahtuma;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.components.XPathHelper;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.exception.UtilException;
import java.util.List;
import org.apache.log4j.Logger;

public class Manifest {
    ManifestReader rl;
    XPathHelper xpathhelper;
    private Logger log4j = Logger.getLogger(Manifest.class);
    private LogHelper logHelper = new LogHelper();
    private String logId;
    private String directory;
    private String filename;
    private ManifestBean manifestBean;

    public Manifest(String directory, String manifestFile) throws PropertyException, UtilException {
        this.xpathhelper = new XPathHelper();
        this.directory = directory;
        this.filename = manifestFile;
        this.rl = new ManifestReader(manifestFile, directory);
        this.readManifest();
    }

    private void readManifest() throws UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        this.rl.readManifest();
        this.manifestBean = this.rl.getManifest();
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(this.logId));
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFilename() {
        return this.filename;
    }

    public List<Palvelutapahtuma> haePalvelutapahtumat() throws UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(this.logId));
        }
        return this.manifestBean.getPalvelutapahtumat();
    }

    public String getPalvelunantaja() throws UtilException {
        return this.manifestBean.getPalvelunantaja();
    }
}

