/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.tasks;

import fi.kanta.arkistopalvelu.olddocuments.exception.ConfigException;
import fi.kanta.arkistopalvelu.olddocuments.exception.MessagingException;
import fi.kanta.arkistopalvelu.olddocuments.exception.ValidatorException;
import fi.kanta.arkistopalvelu.olddocuments.filesystem.FileReader;
import fi.kanta.arkistopalvelu.olddocuments.interfaces.ICompensateDocumentClient;
import fi.kanta.arkistopalvelu.olddocuments.interfaces.IOldDocumentArchiver;
import fi.kanta.arkistopalvelu.olddocuments.logging.DbLogger;
import fi.kanta.arkistopalvelu.olddocuments.logging.IProcessLogger;
import fi.kanta.arkistopalvelu.olddocuments.messaging.dto.ArchiveResponseDTO;
import fi.kanta.arkistopalvelu.olddocuments.metadata.ExecutionMode;
import fi.kanta.arkistopalvelu.olddocuments.metadata.Hoitoasiakirja;
import fi.kanta.arkistopalvelu.olddocuments.metadata.OldDocumentMetadataReader;
import fi.kanta.arkistopalvelu.olddocuments.metadata.Palvelutapahtuma;
import fi.kanta.arkistopalvelu.olddocuments.sign.SignatureChecker;
import fi.kanta.arkistopalvelu.olddocuments.tasks.AsiakirjaData;
import fi.kanta.arkistopalvelu.olddocuments.tasks.HoitoasiakirjaTask;
import fi.kanta.arkistopalvelu.olddocuments.tasks.HoitoasiakirjaTaskResult;
import fi.kanta.arkistopalvelu.olddocuments.tasks.LoaderClientProxies;
import fi.kanta.arkistopalvelu.olddocuments.tasks.PalvelutapahtumaData;
import fi.kanta.arkistopalvelu.olddocuments.tasks.TaskResult;
import fi.kanta.arkistopalvelu.olddocuments.utils.ErrorMessageHelper;
import fi.kanta.arkistopalvelu.olddocuments.utils.LoaderConstants;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.arkistopalvelu.webservices.olddocumentwithcontent.request.AsiakirjaPTReq;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.components.XMLValidator;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.exception.ValidationException;
import fi.kanta.common.util.InternalServiceError;
import fi.kanta.lokipalvelu.webservices.kayttoloki.arkisto.web.ArkistoKayttoLokiResponseDetailWeb;
import fi.kela.kanta.exceptions.XPathHelperVTDException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class PalvelutapahtumaTask
implements Callable<TaskResult> {
    private Logger log4j = Logger.getLogger(PalvelutapahtumaTask.class);
    private LogHelper logHelper;
    private volatile String logId;
    private IProcessLogger logger;
    private static Logger ERROR_LOGGER = Logger.getLogger((String)"errorlog");
    private String subsystem;
    private PalvelutapahtumaData palvelutapahtumaData;
    private boolean checkSignatures;
    private ExecutorService executorService;
    private ExecutionMode mode;
    private boolean asiakirjojentallennusonnistui = true;

    public PalvelutapahtumaTask(PalvelutapahtumaData palvelutapahtumaData, IProcessLogger processLogger, ExecutorService executorService, ExecutionMode mode) throws PropertyException, MalformedURLException, UtilException {
        PropertyHandler props = PropertyHandler.getInstance();
        this.palvelutapahtumaData = palvelutapahtumaData;
        this.logger = processLogger;
        this.logHelper = new LogHelper();
        this.logId = processLogger.getLogId();
        this.subsystem = props.getProperty(this.logId, "subsystem");
        this.checkSignatures = Boolean.parseBoolean(props.getProperty(this.logId, "checksignature"));
        this.executorService = executorService;
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult call() throws IOException, PropertyException, InterruptedException, ValidationException {
        Palvelutapahtuma palvelutapahtuma = this.palvelutapahtumaData.getPalvelutapahtuma();
        String logExtension = "_" + palvelutapahtuma.getOid();
        this.logId = palvelutapahtuma.getOid();
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        DbLogger dblogger = new DbLogger();
        IOldDocumentArchiver archiver = null;
        FileReader reader = new FileReader(this.logId);
        XMLValidator schemaValidator = new XMLValidator();
        ArchiveResponseDTO archiveResponseDTO = null;
        TaskResult taskResult = new TaskResult();
        taskResult.setPalvelutapahtuma(palvelutapahtuma);
        String certificatedate = "2050-01-01T00:00:00Z";
        Object errorMsg = "";
        String errorCode = null;
        boolean error = false;
        ArrayList<Future<HoitoasiakirjaTaskResult>> asFutures = new ArrayList<Future<HoitoasiakirjaTaskResult>>();
        try {
            archiver = LoaderClientProxies.getArkistoClient().getProxy();
            try {
                this.log4j.info((Object)("START THREAD palvelutapahtuma " + palvelutapahtuma.getOid()));
                schemaValidator.validateXML(this.logId, reader.readXMLDoc(palvelutapahtuma.getFile(), true), PropertyHandler.getInstance().getCDASchema());
                String palvelutapahtumaDocText = reader.getContent(palvelutapahtuma.getFile());
                if (this.checkSignatures) {
                    SignatureChecker checker = new SignatureChecker();
                    certificatedate = checker.checkSignatures(this.logId, palvelutapahtumaDocText, this.subsystem, palvelutapahtuma.getFile());
                }
                OldDocumentMetadataReader metadataReader = new OldDocumentMetadataReader(this.logId);
                AsiakirjaPTReq ptRequest = metadataReader.getPalvelutapahtumaReq(this.logId, palvelutapahtuma.getFile(), certificatedate, this.palvelutapahtumaData.getRekisterinpitaja());
                taskResult.setAsiakirjaPTReq(ptRequest);
                taskResult.setSuccess(true);
                String resultCode = "";
                if (!palvelutapahtuma.getSaved()) {
                    if (this.palvelutapahtumaData.isTestMode()) {
                        this.log4j.info((Object)"TESTMODE Palvelutapahtuman tallennus");
                        taskResult.setResultStatus(LoaderConstants.PT_VAK_ARKISTO_RETURN_CODE_SUCCESS);
                        taskResult.setResultDescription("TESTMODE OK");
                        this.logger.writeCompareLog(palvelutapahtuma.getOid());
                    } else {
                        archiveResponseDTO = archiver.sendPTToArchive(this.logId, ptRequest, palvelutapahtumaDocText);
                        if (archiveResponseDTO != null) {
                            resultCode = archiveResponseDTO.getCode();
                            taskResult.setResultStatus(resultCode);
                            if (this.mode.equals((Object)ExecutionMode.RERUN)) {
                                if (resultCode.equals(LoaderConstants.PT_VAK_ARKISTO_RETURN_CODE_SUCCESS) || resultCode.equals("291159")) {
                                    dblogger.logOK(palvelutapahtuma.getOid(), palvelutapahtuma.getFile());
                                    this.logArkistonKaytto(palvelutapahtuma, logExtension, archiveResponseDTO, taskResult, ptRequest);
                                    if (resultCode.equals("291159")) {
                                        ERROR_LOGGER.error((Object)(palvelutapahtuma.getOid() + " oli jo arkistoitu mutta sallitaan koska kyseess\u00e4 uudelleenajo"));
                                    } else {
                                        this.log4j.info((Object)("PT tallennus OK " + palvelutapahtuma.getOid()));
                                    }
                                } else {
                                    taskResult.setSuccess(false);
                                    ERROR_LOGGER.error((Object)(palvelutapahtuma.getFile().getAbsolutePath() + "\n   + Palvelutapahtumavirhe: " + resultCode + ", selite: " + archiveResponseDTO.getMessage() + "\n"));
                                    dblogger.kirjaaVirhe(palvelutapahtuma.getOid(), resultCode, archiveResponseDTO.getMessage(), palvelutapahtuma.getFile());
                                }
                            } else if (resultCode.equals(LoaderConstants.PT_VAK_ARKISTO_RETURN_CODE_SUCCESS)) {
                                dblogger.logOK(palvelutapahtuma.getOid(), palvelutapahtuma.getFile());
                                this.logArkistonKaytto(palvelutapahtuma, logExtension, archiveResponseDTO, taskResult, ptRequest);
                                this.log4j.info((Object)("PT tallennus OK " + palvelutapahtuma.getOid()));
                            } else {
                                taskResult.setSuccess(false);
                                ERROR_LOGGER.error((Object)(palvelutapahtuma.getFile().getAbsolutePath() + "\n   + Palvelutapahtumavirhe: " + resultCode + ", selite: " + archiveResponseDTO.getMessage() + "\n"));
                                dblogger.kirjaaVirhe(palvelutapahtuma.getOid(), resultCode, archiveResponseDTO.getMessage(), palvelutapahtuma.getFile());
                            }
                        } else {
                            taskResult.setSuccess(false);
                        }
                    }
                }
                ExecutorCompletionService<HoitoasiakirjaTaskResult> pool = new ExecutorCompletionService<HoitoasiakirjaTaskResult>(this.executorService);
                if (taskResult.getSuccess() || this.isUniqueKeyConstraintErrorInBruteForceMode(resultCode)) {
                    for (Hoitoasiakirja asiakirja : palvelutapahtuma.getHoitoasiakirjat()) {
                        AsiakirjaData asiakirjaData = new AsiakirjaData(asiakirja, palvelutapahtuma, this.palvelutapahtumaData.getDirectory(), this.palvelutapahtumaData.getLapId(), this.palvelutapahtumaData.getThreadTimeout(), this.palvelutapahtumaData.getRekisterinpitaja(), this.palvelutapahtumaData.isTestMode(), this.palvelutapahtumaData.isBruteForceMode());
                        this.log4j.debug((Object)("asiakirjaData:" + asiakirjaData.getHoitoasiakirja().getOid()));
                        asiakirjaData.setAsiakirjaPTReq(ptRequest);
                        HoitoasiakirjaTask task = new HoitoasiakirjaTask(asiakirjaData, this.logger, this.mode, palvelutapahtuma.getOid());
                        asFutures.add(pool.submit(task));
                    }
                    for (int i = 0; i < asFutures.size(); ++i) {
                        HoitoasiakirjaTaskResult result = (HoitoasiakirjaTaskResult)pool.take().get(this.palvelutapahtumaData.getThreadTimeout(), TimeUnit.MILLISECONDS);
                        this.log4j.debug((Object)(this.logId + " Saatiin vastaus asiakirjojen k\u00e4sittelys\u00e4ikeelt\u00e4, onnistui = " + result.getSuccess()));
                        if (!result.getSuccess()) {
                            this.asiakirjojentallennusonnistui = false;
                        }
                        taskResult.addChildTaskResult(result);
                    }
                }
            }
            catch (ValidatorException e) {
                error = true;
                errorCode = ErrorMessageHelper.getInternalErrorCode(e.getError());
                errorMsg = "Palvelutapahtumavirhe: " + palvelutapahtuma.getOid() + ErrorMessageHelper.getInternalErrorMessage(e.getError());
                this.log4j.error((Object)this.logHelper.formatMsg(this.logId, e.getError()), (Throwable)e);
            }
            catch (ValidationException e) {
                error = true;
                errorCode = ErrorMessageHelper.getInternalErrorCode(e.getInternalServiceError());
                errorMsg = "Palvelutapahtuma-asiakirjan validointi ep\u00e4onnistui: " + palvelutapahtuma.getOid() + ErrorMessageHelper.getInternalErrorMessage(e.getInternalServiceError());
                this.log4j.error((Object)this.logHelper.formatMsg(this.logId, e.getMessage()), (Throwable)e);
                ArrayList<InternalServiceError> errors = new ArrayList<InternalServiceError>();
                InternalServiceError ise = new InternalServiceError();
                ise.setErrorDescription("XML validointi ep\u00e4onnistui");
                ise.setErrorMessage("XML validointi ep\u00e4onnistui");
                ise.setErrorCode(e.getInternalServiceError().getErrorCode());
                errors.add(ise);
                dblogger.kirjaaVirhe(palvelutapahtuma.getOid(), errors, palvelutapahtuma.getFile());
            }
            catch (IOException e) {
                error = true;
                errorMsg = "Palvelutapahtuma-asiakirjaa ei l\u00f6ytynyt: " + palvelutapahtuma.getOid() + " " + e.getMessage();
                this.log4j.error(errorMsg, (Throwable)e);
                this.logger.missingDoc(palvelutapahtuma.getOid(), palvelutapahtuma.getFile().getAbsolutePath());
            }
        }
        catch (PropertyException e) {
            error = true;
            errorCode = ErrorMessageHelper.getInternalErrorCode(e.getInternalServiceError());
            errorMsg = "Konfiguraatiovirhe properties-asetuksissa: " + palvelutapahtuma.getOid() + ErrorMessageHelper.getInternalErrorMessage(e.getInternalServiceError());
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, (String)errorMsg), (Throwable)e);
        }
        catch (IOException e) {
            error = true;
            errorMsg = "Virhe tiedoston k\u00e4sittelyss\u00e4: " + palvelutapahtuma.getOid() + " " + e.getMessage();
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, (String)errorMsg), (Throwable)e);
        }
        catch (XPathHelperVTDException e) {
            error = true;
            errorMsg = "Asiakirjan XML-k\u00e4sittelyvirhe: " + palvelutapahtuma.getOid() + " " + e.getMessage();
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, (String)errorMsg), (Throwable)e);
        }
        catch (ConfigException e) {
            error = true;
            errorCode = ErrorMessageHelper.getInternalErrorCode(e.getError());
            errorMsg = "Konfiguraatiovirhe: " + palvelutapahtuma.getOid() + ErrorMessageHelper.getInternalErrorMessage(e.getError());
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, (String)errorMsg), (Throwable)e);
        }
        catch (MessagingException e) {
            error = true;
            errorMsg = "Palvelukutsuvirhe: " + palvelutapahtuma.getOid() + " " + e.getMessage();
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, (String)errorMsg), (Throwable)e);
        }
        catch (UtilException utilException) {
            Throwable thToLog = utilException;
            if (utilException.getInternalServiceError() != null) {
                thToLog = utilException.getInternalServiceError().getErrorCause();
                errorMsg = "Palvelukutsuvirhe: " + palvelutapahtuma.getOid() + " " + utilException.getInternalServiceError().getErrorDescription();
            } else {
                errorMsg = "Palvelukutsuvirhe: " + palvelutapahtuma.getOid() + " " + utilException.getMessage();
            }
            error = true;
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, (String)errorMsg), thToLog);
        }
        catch (Exception e) {
            error = true;
            errorMsg = "Odottamaton virhe: " + palvelutapahtuma.getOid() + " " + e.getMessage();
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, (String)errorMsg), (Throwable)e);
        }
        finally {
            LoaderClientProxies.getArkistoClient().releaseProxy(archiver);
        }
        if (error) {
            String errCode = errorCode != null ? errorCode : "ERROR";
            taskResult.setResultStatus(errCode);
            taskResult.setResultDescription((String)errorMsg);
            taskResult.setSuccess(false);
            this.log4j.debug((Object)"palvelutapahtumatask success = false");
            ERROR_LOGGER.error((Object)(palvelutapahtuma.getFile().getAbsolutePath() + "\n   + Palvelutapahtumavirhe: " + errCode + ", selite: " + (String)errorMsg + "\n"));
            dblogger.logPalvelutapahtuma(palvelutapahtuma.getOid(), false);
        } else {
            dblogger.logPalvelutapahtuma(palvelutapahtuma.getOid(), this.asiakirjojentallennusonnistui);
            if (this.asiakirjojentallennusonnistui && taskResult.getSuccess()) {
                dblogger.logPalvelutapahtuma(palvelutapahtuma.getOid(), true);
            } else {
                this.log4j.error((Object)("asiakirjojen tallennus EP\u00c4onnistui, dir: " + this.palvelutapahtumaData.getDirectory()));
            }
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(this.logId));
        }
        this.log4j.info((Object)("END THREAD palvelutapahtuma " + palvelutapahtuma.getOid()));
        return taskResult;
    }

    private void logArkistonKaytto(Palvelutapahtuma palvelutapahtuma, String logExtension, ArchiveResponseDTO archiveResponseDTO, TaskResult taskResult, AsiakirjaPTReq ptRequest) throws IOException, InterruptedException, MessagingException {
        ArkistoKayttoLokiResponseDetailWeb usageLogResponse = this.logger.writeUsageLog(this.subsystem, ptRequest, logExtension);
        if ("600000".equals(usageLogResponse.getResultCode())) {
            this.log4j.debug((Object)("Palvelutapahtuma tallennettu k\u00e4ytt\u00f6lokille: " + palvelutapahtuma.getOid()));
            taskResult.setSuccess(true);
            this.logger.writeCompareLog(palvelutapahtuma.getOid());
        } else {
            this.logger.error("Palvelutapahtuman tallennuksen k\u00e4ytt\u00f6lokitus ep\u00e4onnistui " + palvelutapahtuma.getOid());
            this.log4j.error((Object)("Palvelutapahtuman tallennuksen k\u00e4ytt\u00f6lokitus ep\u00e4onnistui " + palvelutapahtuma.getOid()));
            taskResult.setResultStatus(usageLogResponse.getResultCode());
            taskResult.setResultDescription(usageLogResponse.getDescription());
            taskResult.setSuccess(false);
            ERROR_LOGGER.error((Object)(palvelutapahtuma.getFile().getAbsolutePath() + "\n   + Palvelutapahtumavirhe: " + usageLogResponse.getResultCode() + ", selite: " + usageLogResponse.getDescription() + "\n"));
            ArchiveResponseDTO kompensointiResultDetails = this.kompensoiPalvelutapahtuma(palvelutapahtuma);
            if (!kompensointiResultDetails.getCode().equals(LoaderConstants.PT_VAK_ARKISTO_RETURN_CODE_SUCCESS)) {
                this.logger.error("Palvelutapahtuman tallennuksen kompensointi ep\u00e4onnistui: " + palvelutapahtuma.getOid());
                this.log4j.error((Object)("Palvelutapahtuman tallennuksen kompensointi ep\u00e4onnistui: " + palvelutapahtuma.getOid()));
            } else {
                DbLogger dblogger = new DbLogger();
                dblogger.kompensoiasiakirja(palvelutapahtuma.getOid());
            }
        }
    }

    private boolean isUniqueKeyConstraintErrorInBruteForceMode(String resultCode) {
        boolean retValue;
        boolean bl = retValue = this.palvelutapahtumaData.isBruteForceMode() && "291159".equals(resultCode);
        if (retValue) {
            this.log4j.debug((Object)("Palvelutapahtuma l\u00f6ytyy jo kannasta, brute force moodissa se tulkitaan ok-tilanteeksi: " + resultCode));
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchiveResponseDTO kompensoiPalvelutapahtuma(Palvelutapahtuma palvelutapahtuma) throws InterruptedException, MessagingException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        ICompensateDocumentClient kompensointiClient = null;
        ArchiveResponseDTO kompensointiArchiveResponseDTO = null;
        try {
            this.log4j.info((Object)("Kutsutaan kompensointia palvelutapahtuma-asiakirjalle: " + palvelutapahtuma.getOid()));
            kompensointiClient = LoaderClientProxies.getKompensointiClient().getProxy();
            kompensointiArchiveResponseDTO = kompensointiClient.execute(this.logId, palvelutapahtuma.getOid(), "4");
        }
        catch (Throwable throwable) {
            LoaderClientProxies.getKompensointiClient().releaseProxy(kompensointiClient);
            throw throwable;
        }
        LoaderClientProxies.getKompensointiClient().releaseProxy(kompensointiClient);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(this.logId));
        }
        return kompensointiArchiveResponseDTO;
    }
}

