/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.ReplayPhase;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.VerifiedExpectation;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationArguments;

public abstract class BaseVerificationPhase
extends TestOnlyPhase {
    @Nonnull
    final ReplayPhase replayPhase;
    @Nonnull
    private final List<VerifiedExpectation> currentVerifiedExpectations;
    @Nullable
    Expectation currentVerification;
    int replayIndex;
    @Nullable
    Error pendingError;
    @Nullable
    ExpectedInvocation matchingInvocationWithDifferentArgs;

    BaseVerificationPhase(@Nonnull ReplayPhase replayPhase) {
        super(replayPhase.executionState);
        this.replayPhase = replayPhase;
        this.currentVerifiedExpectations = new ArrayList<VerifiedExpectation>();
    }

    @Override
    @Nullable
    final Object handleInvocation(@Nullable Object mock, int mockAccess, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nullable String genericSignature, boolean withRealImpl, @Nonnull Object[] args) {
        if (this.pendingError != null) {
            this.replayPhase.failureState.setErrorThrown(this.pendingError);
            this.pendingError = null;
            return null;
        }
        this.matchInstance = mock != null && (this.executionState.equivalentInstances.isReplacementInstance(mock, mockNameAndDesc) || BaseVerificationPhase.isEnumElement(mock));
        ExpectedInvocation currentInvocation = new ExpectedInvocation(mock, mockAccess, mockClassDesc, mockNameAndDesc, this.matchInstance, genericSignature, args);
        currentInvocation.arguments.setMatchers(this.argMatchers);
        this.currentVerification = new Expectation(currentInvocation);
        this.currentExpectation = null;
        this.currentVerifiedExpectations.clear();
        List<ExpectedInvocation> matchingInvocationsWithDifferentArgs = this.findExpectation(mock, mockClassDesc, mockNameAndDesc, args);
        this.argMatchers = null;
        if (this.replayPhase.failureState.getErrorThrown() != null) {
            return null;
        }
        if (this.currentExpectation == null) {
            this.pendingError = this.currentVerification.invocation.errorForMissingInvocation(matchingInvocationsWithDifferentArgs);
            this.currentExpectation = this.currentVerification;
        }
        return this.currentExpectation.invocation.getDefaultValueForReturnType();
    }

    @Nonnull
    abstract List<ExpectedInvocation> findExpectation(@Nullable Object var1, @Nonnull String var2, @Nonnull String var3, @Nonnull Object[] var4);

    final boolean matches(@Nullable Object mock, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nonnull Object[] args, @Nonnull Expectation replayExpectation, @Nullable Object replayInstance, @Nonnull Object[] replayArgs) {
        boolean matching;
        ExpectedInvocation invocation = replayExpectation.invocation;
        boolean constructor = invocation.isConstructor();
        Map<Object, Object> replacementMap = this.getReplacementMap();
        this.matchingInvocationWithDifferentArgs = null;
        if (invocation.isMatch(mock, mockClassDesc, mockNameAndDesc, replacementMap) && (matching = mock == null || invocation.instance == null || constructor && !this.matchInstance ? true : this.executionState.equivalentInstances.areMatchingInstances(this.matchInstance, invocation.instance, mock))) {
            this.matchingInvocationWithDifferentArgs = invocation;
            InvocationArguments invocationArguments = invocation.arguments;
            List<ArgumentMatcher<?>> originalMatchers = invocationArguments.getMatchers();
            Object[] originalArgs = invocationArguments.prepareForVerification(args, this.argMatchers);
            boolean argumentsMatch = invocationArguments.isMatch(replayArgs, this.getInstanceMap());
            invocationArguments.setValuesAndMatchers(originalArgs, originalMatchers);
            if (argumentsMatch) {
                this.addVerifiedExpectation(replayExpectation, replayArgs);
                return true;
            }
        }
        return false;
    }

    abstract void addVerifiedExpectation(@Nonnull Expectation var1, @Nonnull Object[] var2);

    final void addVerifiedExpectation(@Nonnull VerifiedExpectation verifiedExpectation) {
        this.executionState.verifiedExpectations.add(verifiedExpectation);
        this.currentVerifiedExpectations.add(verifiedExpectation);
    }

    @Override
    final void setMaxInvocationCount(int maxInvocations) {
        if (maxInvocations == 0 || this.pendingError == null) {
            super.setMaxInvocationCount(maxInvocations);
        }
    }

    @Nullable
    Error endVerification() {
        return this.pendingError;
    }

    @Nullable
    final Object getArgumentValueForCurrentVerification(@Nonnegative int parameterIndex) {
        List<VerifiedExpectation> verifiedExpectations = this.executionState.verifiedExpectations;
        if (verifiedExpectations.isEmpty()) {
            return this.currentVerification == null ? null : this.currentVerification.invocation.getArgumentValues()[parameterIndex];
        }
        VerifiedExpectation lastMatched = verifiedExpectations.get(verifiedExpectations.size() - 1);
        return lastMatched.arguments[parameterIndex];
    }

    @Nonnull
    public final <T> List<T> getNewInstancesMatchingVerifiedConstructorInvocation() {
        ArrayList<Object> newInstances = new ArrayList<Object>();
        for (VerifiedExpectation verifiedExpectation : this.currentVerifiedExpectations) {
            Object newInstance = verifiedExpectation.captureNewInstance();
            newInstances.add(newInstance);
        }
        return newInstances;
    }
}

