/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.BaseVerificationPhase;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.ReplayPhase;
import mockit.internal.expectations.VerifiedExpectation;
import mockit.internal.expectations.invocation.ExpectedInvocation;

class UnorderedVerificationPhase
extends BaseVerificationPhase {
    @Nonnull
    private final List<VerifiedExpectation> verifiedExpectations = new ArrayList<VerifiedExpectation>();

    UnorderedVerificationPhase(@Nonnull ReplayPhase replayPhase) {
        super(replayPhase);
    }

    @Override
    @Nonnull
    final List<ExpectedInvocation> findExpectation(@Nullable Object mock, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nonnull Object[] args) {
        if (!this.matchInstance && this.executionState.isToBeMatchedOnInstance(mock, mockNameAndDesc)) {
            this.matchInstance = true;
        }
        this.replayIndex = -1;
        List<Expectation> expectationsInReplayOrder = this.replayPhase.invocations;
        Expectation verification = this.currentVerification;
        ArrayList<ExpectedInvocation> matchingInvocationsWithDifferentArgs = new ArrayList<ExpectedInvocation>();
        int n = expectationsInReplayOrder.size();
        for (int i = 0; i < n; ++i) {
            Object[] replayArgs;
            Object replayInstance;
            Expectation replayExpectation = expectationsInReplayOrder.get(i);
            if (this.matches(mock, mockClassDesc, mockNameAndDesc, args, replayExpectation, replayInstance = this.replayPhase.invocationInstances.get(i), replayArgs = this.replayPhase.invocationArguments.get(i))) {
                this.replayIndex = i;
                if (verification != null) {
                    ++verification.constraints.invocationCount;
                }
                this.currentExpectation = replayExpectation;
                continue;
            }
            if (this.matchingInvocationWithDifferentArgs == null) continue;
            matchingInvocationsWithDifferentArgs.add(this.matchingInvocationWithDifferentArgs);
        }
        if (verification != null && this.replayIndex >= 0) {
            this.pendingError = this.verifyConstraints(verification);
        }
        return matchingInvocationsWithDifferentArgs;
    }

    @Nullable
    private Error verifyConstraints(@Nonnull Expectation verification) {
        ExpectedInvocation lastInvocation = this.replayPhase.invocations.get((int)this.replayIndex).invocation;
        Object[] lastArgs = this.replayPhase.invocationArguments.get(this.replayIndex);
        return verification.verifyConstraints(lastInvocation, lastArgs, 1, -1);
    }

    @Override
    final void addVerifiedExpectation(@Nonnull Expectation expectation, @Nonnull Object[] args) {
        VerifiedExpectation verifiedExpectation = new VerifiedExpectation(expectation, args, this.argMatchers, -1);
        this.addVerifiedExpectation(verifiedExpectation);
        this.verifiedExpectations.add(verifiedExpectation);
    }

    @Override
    final void handleInvocationCountConstraint(int minInvocations, int maxInvocations) {
        Error errorThrown;
        this.pendingError = null;
        Expectation verifying = this.currentVerification;
        if (verifying == null) {
            return;
        }
        if (this.replayIndex >= 0) {
            ExpectedInvocation replayInvocation = this.replayPhase.invocations.get((int)this.replayIndex).invocation;
            Object[] replayArgs = this.replayPhase.invocationArguments.get(this.replayIndex);
            errorThrown = verifying.verifyConstraints(replayInvocation, replayArgs, minInvocations, maxInvocations);
        } else {
            errorThrown = verifying.verifyConstraints(minInvocations);
        }
        if (errorThrown != null) {
            throw errorThrown;
        }
    }
}

