/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Utilities {
    @Nonnull
    public static final Object[] NO_ARGS = new Object[0];
    public static final boolean JAVA8;
    public static final boolean HOTSPOT_VM;

    private Utilities() {
    }

    public static void ensureThatMemberIsAccessible(@Nonnull AccessibleObject classMember) {
        if (!classMember.isAccessible()) {
            classMember.setAccessible(true);
        }
    }

    public static Method getAnnotatedMethod(Class<?> cls, Class<? extends Annotation> annotation) {
        for (Method method : cls.getMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            return method;
        }
        return null;
    }

    public static Method getAnnotatedDeclaredMethod(Class<?> cls, Class<? extends Annotation> annotation) {
        for (Method method : cls.getDeclaredMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            return method;
        }
        return null;
    }

    @Nonnull
    public static Class<?> getClassType(@Nonnull Type declaredType) {
        while (true) {
            if (declaredType instanceof Class) {
                return (Class)declaredType;
            }
            if (declaredType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)declaredType).getRawType();
            }
            if (declaredType instanceof GenericArrayType) {
                declaredType = ((GenericArrayType)declaredType).getGenericComponentType();
                continue;
            }
            if (declaredType instanceof TypeVariable) {
                declaredType = ((TypeVariable)declaredType).getBounds()[0];
                continue;
            }
            if (!(declaredType instanceof WildcardType)) break;
            declaredType = ((WildcardType)declaredType).getUpperBounds()[0];
        }
        throw new IllegalArgumentException("Type of unexpected kind: " + declaredType);
    }

    public static boolean containsReference(@Nonnull List<?> references, @Nullable Object toBeFound) {
        for (Object reference : references) {
            if (reference != toBeFound) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static String getClassFileLocationPath(@Nonnull Class<?> aClass) {
        CodeSource codeSource = aClass.getProtectionDomain().getCodeSource();
        return Utilities.getClassFileLocationPath(codeSource);
    }

    @Nonnull
    public static String getClassFileLocationPath(@Nonnull CodeSource codeSource) {
        String locationPath = codeSource.getLocation().getPath();
        try {
            locationPath = URLDecoder.decode(locationPath, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return locationPath;
    }

    static {
        float javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        JAVA8 = javaVersion >= 1.8f;
        String vmName = System.getProperty("java.vm.name");
        HOTSPOT_VM = vmName.contains("HotSpot") || vmName.contains("OpenJDK");
    }
}

