/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fi.kanta.arkistopalvelu.olddocuments.exception.ErrorWrapperLoader;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class ThlKoodistoClient {
    private static final Logger log = LogManager.getLogger(ThlKoodistoClient.class);
    private static RestTemplate restTemplate;
    private static String uriTemplate;
    private static LogHelper logHelper;

    public boolean isCodeActive(String koodisto, String koodistoVersio, String koodi, String logId) throws UtilException {
        log.debug(() -> logHelper.formatMsgBgn(logId));
        String url = MessageFormat.format(uriTemplate, koodisto, koodistoVersio, koodi);
        log.info("url: " + url);
        ResponseEntity forEntity = restTemplate.getForEntity(url, String.class, new Object[0]);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = null;
        try {
            jsonNode = objectMapper.readTree((String)forEntity.getBody());
        }
        catch (Exception e) {
            e.printStackTrace();
            InternalServiceError error = ErrorWrapperLoader.getInstance().getError("0001");
            error.setErrorMessage("Virhe yhteydess\u00e4 koodistopalvelu.kanta.fi sovellukseen");
            error.setErrorDescription(e.getMessage());
            log.error(logHelper.formatMsg(logId, error));
            log.error("logId:" + logId + ",koodisto:" + koodisto + ", koodistoVersio:" + koodistoVersio + ", koodi:" + koodi + ",url:" + url);
            throw new UtilException(error, (Throwable)e);
        }
        String msgStatus = jsonNode.get("status").asText();
        log.debug("msgStatus:" + msgStatus);
        log.debug(() -> logHelper.formatMsgEnd(logId));
        return "ACTIVE".equalsIgnoreCase(msgStatus);
    }

    static {
        logHelper = new LogHelper();
        try {
            uriTemplate = PropertyHandler.getInstance().getProperty("", "thl_koodisto_url_template");
        }
        catch (PropertyException e) {
            log.error(logHelper.formatMsg("Koodisto propertyjen luku ep\u00e4onnistui, poistutaan ohjelmasta", e.getMessage()));
            System.err.println("Koodisto propertyjen luku ep\u00e4onnistui, poistutaan ohjelmasta");
            System.exit(1);
        }
        restTemplate = new RestTemplate();
    }
}

