/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.messaging;

import fi.kanta.arkistopalvelu.olddocuments.exception.MessagingException;
import fi.kanta.arkistopalvelu.olddocuments.interfaces.IFetchCodesClient;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCodeIn;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCodeResponse;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.Peruskoodisto;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.Peruskoodisto_Service;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;

public class FetchCodesClientInternal
implements IFetchCodesClient {
    private static CacheManager cacheManager;
    private static Cache<String, BasicCodeResponse> codecache;
    Logger log = Logger.getLogger(FetchCodesClientInternal.class);
    private LogHelper logHelper = new LogHelper();
    private String logId;
    private Peruskoodisto koodisto;

    public FetchCodesClientInternal() throws MessagingException {
        try {
            QName serviceName = new QName(PropertyHandler.getInstance().getProperty(this.logId, "koodistopalvelu"), PropertyHandler.getInstance().getProperty(this.logId, "koodistopalveluservice"));
            URL url = new URL(PropertyHandler.getInstance().getProperty(this.logId, "koodistopalveluurl"));
            Peruskoodisto_Service service = new Peruskoodisto_Service(url, serviceName);
            this.koodisto = service.getPeruskoodisto();
        }
        catch (PropertyException | MalformedURLException e) {
            throw new MessagingException(e);
        }
    }

    private static void initcache() {
        cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache("codecache", (Builder)CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, BasicCodeResponse.class, (Builder)ResourcePoolsBuilder.heap((long)10000L))).build();
        cacheManager.init();
        codecache = cacheManager.getCache("codecache", String.class, BasicCodeResponse.class);
    }

    @Override
    public List<BasicCodeResponse> execute(String logId, List<BasicCodeIn> codesIn) throws MessagingException {
        List<Object> retValues = new ArrayList<BasicCodeResponse>();
        try {
            this.log.debug((Object)this.logHelper.formatMsgBgn(logId));
            for (BasicCodeIn bci : codesIn) {
                String key = bci.getVersionoid() + "@@@" + bci.getCodeid();
                if (codecache.containsKey((Object)key)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)this.logHelper.formatMsg(logId, "Cache hit: " + key));
                    }
                    retValues.add((BasicCodeResponse)codecache.get((Object)key));
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)this.logHelper.formatMsg(logId, "Cache miss: " + key));
                }
                ArrayList<BasicCodeIn> codeIn = new ArrayList<BasicCodeIn>();
                codeIn.add(bci);
                retValues = this.koodisto.getBasicCode(codeIn, logId);
                if (retValues.size() == 1) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)this.logHelper.formatMsg(logId, "Cache put: " + key));
                    }
                    codecache.put((Object)key, (Object)((BasicCodeResponse)retValues.get(0)));
                    retValues.add((BasicCodeResponse)retValues.get(0));
                    continue;
                }
                this.log.error((Object)this.logHelper.formatMsg(logId, "Virhe, haettiin yht\u00e4 koodia saatiin vastauksia eri m\u00e4\u00e4r\u00e4 kuin yksi, vastausta ei cacheteta"));
            }
            this.log.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        catch (ClassCastException ex) {
            throw new MessagingException(ex);
        }
        return retValues;
    }

    static {
        FetchCodesClientInternal.initcache();
    }
}

