/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.logging;

import fi.kanta.arkistopalvelu.olddocuments.exception.ConfigException;
import fi.kanta.arkistopalvelu.olddocuments.exception.ErrorWrapperLoader;
import fi.kanta.arkistopalvelu.olddocuments.logging.IProcessLogger;
import fi.kanta.arkistopalvelu.olddocuments.metadata.DocumentData;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.arkistopalvelu.webservices.RequestResponseInteraction;
import fi.kanta.arkistopalvelu.webservices.olddocumentwithcontent.request.AsiakirjaHAReq;
import fi.kanta.arkistopalvelu.webservices.olddocumentwithcontent.request.AsiakirjaPTReq;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.util.InternalServiceError;
import fi.kanta.lokipalvelu.webservices.kayttoloki.arkisto.ArkistoKayttolokiSOAPType;
import fi.kanta.lokipalvelu.webservices.kayttoloki.arkisto.web.ArkistoKayttoLokiResponseDetailWeb;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class ProcessLoggerSynchronized
implements IProcessLogger {
    private boolean palveluTapahtumaOpen = false;
    private boolean docOpen = false;
    private boolean logAll = true;
    private boolean bruteForceMode = false;
    private boolean rerunOpen = false;
    private boolean rerunPalvelutapahtuma = false;
    private String logPath = null;
    private String organizationid = null;
    private String logId = null;
    private File logFile = null;
    private File rerunFile = null;
    private File compareFile = null;
    private FileWriter fw = null;
    private FileWriter rerunW = null;
    private FileWriter compareW = null;
    private DocumentData currentPalvelutapahtuma = null;
    private Logger log4j;
    private LogHelper logHelper = null;
    private ArkistoKayttolokiSOAPType proxy;
    private Long starttime = 0L;
    private int ptSuccessCount = 0;
    private int ptFailCount = 0;
    private int ptDocFoundCount = 0;
    private int docSuccessCount = 0;
    private int docFailCount = 0;
    private int docFoundCount = 0;
    private int missingDocCount = 0;
    private ErrorWrapperLoader errorWrapper;
    private boolean createRerunLog;

    public ProcessLoggerSynchronized(String logId) throws PropertyException, MalformedURLException {
        this.logId = logId;
        this.logHelper = new LogHelper();
        this.log4j = Logger.getLogger(ProcessLoggerSynchronized.class);
        this.logAll = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(logId, "logAll"));
        this.createRerunLog = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(logId, "rerunlog"));
        this.bruteForceMode = Boolean.parseBoolean(PropertyHandler.getInstance().getProperty(logId, "bruteforcemode"));
        this.errorWrapper = ErrorWrapperLoader.getInstance();
    }

    private ArkistoKayttolokiSOAPType getKayttolokiProxy() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLog(String directory, String logName) throws IOException, ConfigException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            if (!((String)directory).endsWith(File.separator)) {
                directory = (String)directory + File.separator;
            }
            this.logPath = directory;
            this.starttime = System.currentTimeMillis();
            Object fileName = logName;
            if (logName == null) {
                fileName = this.logId + this.hashCode() + "_olddocuments_log.txt";
            }
            this.logFile = new File(this.logPath + (String)fileName);
            if (!this.logFile.createNewFile()) {
                this.log4j.error((Object)("Ei saatu luotua lokitiedostoa:" + String.valueOf(this.logFile)));
                InternalServiceError error = this.errorWrapper.getError("0018");
                throw new ConfigException(error);
            }
            this.fw = new FileWriter(this.logFile);
            this.fw.write("Ajon aloitus: ");
            this.fw.write(new Date(this.starttime).toString());
            this.fw.write("\n");
            this.fw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCompareLog(String logName) throws IOException, ConfigException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            this.compareFile = new File(this.logPath + "compare_" + logName);
            if (!this.compareFile.createNewFile()) {
                this.log4j.error((Object)("Ei saatu luotua lokitiedostoa:" + String.valueOf(this.compareFile)));
                InternalServiceError error = this.errorWrapper.getError("0018");
                this.log4j.error((Object)this.logHelper.formatMsg(this.logId, error));
                throw new ConfigException(error);
            }
            this.compareW = new FileWriter(this.compareFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRerunLog() throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            this.rerunFile = new File(this.logPath + this.logId + "_rerun_log.xml");
            if (this.rerunFile.createNewFile()) {
                this.rerunW = new FileWriter(this.rerunFile);
                this.rerunW.write(this.openRerunFile());
                this.rerunW.flush();
            } else {
                this.log4j.error((Object)("Ei saatu luotua lokitiedostoa:" + String.valueOf(this.rerunFile)));
            }
        }
    }

    private String openRerunFile() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?><palvelutapahtumat palvelujenantaja=\"");
        sb.append(this.organizationid);
        sb.append("\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"Koontitiedosto.xsd\">");
        return sb.toString();
    }

    private String closeRerunFile() {
        return "</palvelutapahtumat>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeLog() throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            this.fw.flush();
            try {
                if (this.palveluTapahtumaOpen) {
                    if (this.docOpen) {
                        this.closeAsiakirja(null, null, "Asiakirjan k\u00e4sittely auki lokia suljettaessa", false);
                    }
                    this.closePalveluTapahtuma(null, null, "Palvelutapahtuman k\u00e4sittely auki lokia suljettaessa", false);
                }
            }
            catch (Exception e) {
                this.log4j.error((Object)"virhe login sulkemisessa", (Throwable)e);
            }
            finally {
                this.fw.write("\n\nAjon lopetus: ");
                this.fw.write(new Date().toString());
                this.fw.write("\n");
                this.fw.flush();
                this.fw.write("\nOnnistuneita palvelutapahtumia: " + this.ptSuccessCount);
                this.fw.write("\nEp\u00e4onnistuneita palvelutapahtumia: " + this.ptFailCount);
                if (this.bruteForceMode) {
                    this.fw.write("\nKannassa valmiiksi palvelutapahtumia: " + this.ptDocFoundCount);
                }
                this.fw.write("\nYhteens\u00e4: " + (this.ptSuccessCount + this.ptFailCount + this.ptDocFoundCount));
                this.fw.write("\nOnnistuneita asiakirjoja: " + this.docSuccessCount);
                this.fw.write("\nEp\u00e4onnistuneita asiakirjoja: " + this.docFailCount);
                if (this.bruteForceMode) {
                    this.fw.write("\nKannassa valmiiksi asiakirjoja: " + this.docFoundCount);
                }
                this.fw.write("\nYhteens\u00e4: " + (this.docSuccessCount + this.docFailCount + this.docFoundCount));
                this.fw.write("\n");
                this.fw.flush();
                this.fw.write("\nPuuttuvia asiakirjoja: " + this.missingDocCount);
                this.fw.write("\nAjo kesti: " + (System.currentTimeMillis() - this.starttime) + " millisekuntia");
                this.fw.flush();
                this.fw.close();
            }
            if (this.rerunOpen) {
                if (!this.rerunPalvelutapahtuma) {
                    this.closeRerunPalveluTapahtuma(false);
                }
                this.closeRerunLog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeRerunLog() throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            this.rerunW.write(this.closeRerunFile());
            this.rerunW.flush();
            this.rerunW.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeCompareLog() throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            this.compareW.flush();
            this.compareW.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCompareLog(String string) throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)("Compare: " + string));
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            this.compareW.write(string + "\n");
            this.compareW.flush();
        }
    }

    @Override
    public void flushLog() throws IOException {
        this.fw.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openPalveluTapahtuma(DocumentData dd) throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        this.log4j.debug((Object)("Tallennetaan palvelutapahtuma: " + dd.getOid()));
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            this.palveluTapahtumaOpen = true;
            this.currentPalvelutapahtuma = dd;
            if (this.logAll) {
                this.fw.write("\n\nAloitetaan palvelutapahtuma: ");
                this.fw.write(dd.getOid());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openPalveluTapahtuma(AsiakirjaPTReq req) throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        String oid = req.getAsiakirja().get(0).getAsiakirjanTunnisteTiedot().getCdaId().getValue();
        this.log4j.debug((Object)("Lokitetaan palvelutapahtuma: " + oid));
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            this.palveluTapahtumaOpen = true;
            if (this.logAll) {
                this.fw.write("\n\nAloitetaan palvelutapahtuma: ");
                this.fw.write(oid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openRerunPalveluTapahtuma(String oid) throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            if (!this.rerunOpen) {
                this.startRerunLog();
                this.rerunOpen = true;
            }
            if (!this.rerunPalvelutapahtuma) {
                this.rerunW.write("<palvelutapahtuma id=\"" + oid + "\">");
                this.rerunPalvelutapahtuma = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePalveluTapahtuma(String oid, String statusCode, String message, boolean success) throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            this.palveluTapahtumaOpen = false;
            if (success) {
                ++this.ptSuccessCount;
                if (this.logAll) {
                    this.fw.write("\nPalvelutapahtuma k\u00e4sitelty onnistuneesti: ");
                    this.fw.write(oid);
                    this.fw.flush();
                }
            } else {
                if (this.bruteForceMode && statusCode.equals("291159")) {
                    ++this.ptDocFoundCount;
                    this.fw.write("\nPalvelutapahtuman k\u00e4sittely onnistui: ");
                } else {
                    ++this.ptFailCount;
                    this.fw.write("\nPalvelutapahtuman k\u00e4sittely ep\u00e4onnistui: ");
                }
                this.fw.write(oid);
                if (!"ERROR".equals(statusCode)) {
                    this.fw.write(" Paluuarvo: ");
                    this.fw.write(statusCode);
                    this.fw.flush();
                }
                this.fw.write(" Viesti: ");
                this.fw.write(message);
                this.fw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeRerunPalveluTapahtuma(boolean success) throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            if (this.rerunPalvelutapahtuma) {
                if (success) {
                    this.rerunW.write("<success/>");
                } else {
                    this.rerunW.write("<fail/>");
                }
                this.rerunW.write("</palvelutapahtuma>");
                this.rerunW.flush();
            }
            this.rerunPalvelutapahtuma = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openAsiakirja(String oid) throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            this.log4j.debug((Object)("Tallennetaan asiakirja: " + oid));
            this.docOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAsiakirja(String oid, String statusCode, String message, boolean success) throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            boolean isOpen = this.docOpen;
            this.docOpen = false;
            if (success) {
                if (isOpen) {
                    ++this.docSuccessCount;
                }
                if (this.logAll) {
                    this.fw.write("\nAsiakirja: ");
                    this.fw.write(oid + ": " + ("".equals(message) ? "OK" : message));
                    this.fw.flush();
                }
            } else {
                if (isOpen) {
                    if (this.bruteForceMode && statusCode.equals("291159")) {
                        ++this.docFoundCount;
                        this.fw.write("\nAsiakirjan k\u00e4sittely onnistui: ");
                        this.fw.write(oid);
                    } else {
                        ++this.docFailCount;
                        this.fw.write("\nAsiakirjan k\u00e4sittely ep\u00e4onnistui: ");
                        this.fw.write(oid);
                        this.fw.write(": ERROR ");
                    }
                }
                this.fw.write(" Paluuarvo: ");
                this.fw.write(statusCode);
                this.fw.write(" Viesti: ");
                this.fw.write(message);
                if (this.currentPalvelutapahtuma != null) {
                    this.fw.write(" Asiakirjan palvelutapahtuma: ");
                    this.fw.write(this.currentPalvelutapahtuma.getOid());
                }
                this.fw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rerunAsiakirja(String oid) throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            if (!this.rerunPalvelutapahtuma) {
                if (this.currentPalvelutapahtuma != null) {
                    this.openRerunPalveluTapahtuma(this.currentPalvelutapahtuma.getOid());
                } else {
                    this.openRerunPalveluTapahtuma("Oid ei tiedossa");
                }
            }
            this.rerunW.write("<asiakirja id=\"" + oid + "\" status=\"fail\" />");
            this.rerunW.flush();
        }
    }

    @Override
    public ArkistoKayttoLokiResponseDetailWeb writeUsageLog(String subsystem, DocumentData dd, RequestResponseInteraction ptresult, String logExtension) {
        String loggerID = this.logId + logExtension;
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(loggerID));
            this.log4j.debug((Object)("Kirjoitetaan k\u00e4ytt\u00f6lokia: " + dd.getOid()));
        }
        this.log4j.debug((Object)"k\u00e4ytt\u00f6loki null logger");
        ArkistoKayttoLokiResponseDetailWeb usageLogResponse = new ArkistoKayttoLokiResponseDetailWeb();
        usageLogResponse.setResultCode("600000");
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(loggerID));
        }
        return usageLogResponse;
    }

    @Override
    public ArkistoKayttoLokiResponseDetailWeb writeUsageLog(String subsystem, AsiakirjaHAReq ptreq, String logExtension) {
        String loggerID = this.logId + logExtension;
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(loggerID));
        }
        this.log4j.debug((Object)"k\u00e4ytt\u00f6loki null logger");
        ArkistoKayttoLokiResponseDetailWeb usageLogResponse = new ArkistoKayttoLokiResponseDetailWeb();
        usageLogResponse.setResultCode("600000");
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(loggerID));
        }
        return usageLogResponse;
    }

    @Override
    public ArkistoKayttoLokiResponseDetailWeb writeUsageLog(String subsystem, AsiakirjaPTReq ptreq, String logExtension) {
        String loggerID = this.logId + logExtension;
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(loggerID));
        }
        this.log4j.debug((Object)"k\u00e4ytt\u00f6loki null logger");
        ArkistoKayttoLokiResponseDetailWeb usageLogResponse = new ArkistoKayttoLokiResponseDetailWeb();
        usageLogResponse.setResultCode("600000");
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(loggerID));
        }
        return usageLogResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(String string) throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        this.log4j.error((Object)string);
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            this.fw.write("\n" + string);
            this.fw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String string) throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        this.log4j.debug((Object)string);
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            this.fw.write("\n" + string);
            this.fw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void missingDoc(String docOid, String docPath) throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            ++this.missingDocCount;
            this.fw.write("\n Puuttuva asiakirja: " + docOid + " polusta: " + docPath);
            this.fw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void palvelunantaja(String oid) throws IOException {
        if (!this.createRerunLog) {
            return;
        }
        ProcessLoggerSynchronized processLoggerSynchronized = this;
        synchronized (processLoggerSynchronized) {
            this.organizationid = oid;
            this.fw.write("\n Ajon palvelunantaja = : " + oid);
            this.fw.flush();
        }
    }

    @Override
    public String getLogId() {
        return this.logId;
    }
}

