/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.logging;

import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.common.exception.PropertyException;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SQLLogger {
    private static SQLLogger instance = new SQLLogger();
    private FileWriter fw = null;
    private static Logger log4j = Logger.getLogger(SQLLogger.class);

    private SQLLogger() {
    }

    public static SQLLogger getInstance() {
        return instance;
    }

    public synchronized void logEntry(String sql, String ... values) {
        if (this.fw == null) {
            this.initfw();
        }
        try {
            String sql2 = sql;
            for (String value : values) {
                StringBuilder builder = new StringBuilder();
                builder.append("'");
                builder.append(value);
                builder.append("'");
                sql2 = sql2.replaceFirst("\\?", builder.toString());
            }
            this.fw.write(sql2);
            this.fw.write("\n");
            this.fw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initfw() {
        try {
            String redolog = PropertyHandler.getInstance().getProperty("", "sqllog");
            this.fw = new FileWriter(redolog);
        }
        catch (PropertyException | IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

