/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.messaging;

import fi.kanta.arkistopalvelu.olddocuments.client.ThlKoodistoClient;
import fi.kanta.arkistopalvelu.olddocuments.exception.MessagingException;
import fi.kanta.arkistopalvelu.olddocuments.interfaces.IFetchCodesClient;
import fi.kanta.arkistopalvelu.olddocuments.messaging.CacheValueEntry;
import fi.kanta.common.components.LogHelper;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCode;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCodeIn;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCodeResponse;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCodeResponseDetails;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.Code;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;

public class FetchCodesClient
implements IFetchCodesClient {
    private static final String INVALID_CODE = "invalid";
    private static final String VALID_CODE = "valid";
    private static final String MV_SEPARATOR = "|>--<|";
    private static Logger log = Logger.getLogger(FetchCodesClient.class);
    private static LogHelper logHelper;
    private static Cache<String, CacheValueEntry> codecache;
    private static String cachefile;
    private static long tTL;

    public FetchCodesClient() {
        logHelper = new LogHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(String logId) {
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(new File(cachefile));
            for (Cache.Entry e : codecache) {
                writer.write((String)e.getKey() + MV_SEPARATOR + ((CacheValueEntry)e.getValue()).getValue() + MV_SEPARATOR + ((CacheValueEntry)e.getValue()).getCreationtime().getTime());
                writer.write("\n");
                writer.flush();
            }
        }
        catch (IOException e1) {
            log.error((Object)"Virhe cachen persistoinnissa...", (Throwable)e1);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setField(Object obj, String fieldName, List list) throws NoSuchFieldException, IllegalAccessException {
        Field field = obj.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(obj, list);
    }

    private static void initcache() {
        CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache("codecache", (Builder)CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, CacheValueEntry.class, (Builder)ResourcePoolsBuilder.heap((long)10000L))).build();
        cacheManager.init();
        codecache = cacheManager.getCache("codecache", String.class, CacheValueEntry.class);
    }

    private static void populatecache() {
        try (BufferedReader br = new BufferedReader(new FileReader(cachefile));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] values = line.split(Pattern.quote(MV_SEPARATOR));
                long fetchdate = Long.parseLong(values[2]);
                long currentdate = new Date().getTime();
                if (currentdate < fetchdate + 86400L + tTL) {
                    log.debug((Object)("add entry to cache: " + values[0]));
                    CacheValueEntry cve = new CacheValueEntry(values[1], new Date(fetchdate));
                    codecache.put((Object)values[0], (Object)cve);
                    continue;
                }
                log.debug((Object)("Entry has expired, not caching: " + values[0]));
            }
        }
        catch (IOException e1) {
            log.error((Object)"Cachen lukemisessa virhe...", (Throwable)e1);
        }
    }

    @Override
    public List<BasicCodeResponse> execute(String logId, List<BasicCodeIn> codesIn) throws MessagingException {
        ArrayList<BasicCodeResponse> responses = new ArrayList<BasicCodeResponse>();
        try {
            log.debug((Object)logHelper.formatMsgBgn(logId));
            for (BasicCodeIn in : codesIn) {
                String versionOid = in.getVersionoid();
                String scode = in.getCodeid();
                BasicCodeResponse response = new BasicCodeResponse();
                BasicCodeResponseDetails detail = new BasicCodeResponseDetails();
                BasicCode basiccode = null;
                boolean isrequestvalid = this.validateCodeIn(logId, versionOid, scode);
                if (isrequestvalid && this.isCode(logId, versionOid + "@" + scode)) {
                    log.debug((Object)(versionOid + "@" + scode + " OK"));
                    detail.setResultCode("400000");
                    basiccode = new BasicCode();
                    basiccode.setStatus(Integer.valueOf(0));
                    basiccode.setVersionoid(versionOid);
                    basiccode.setLanguage("fi");
                    Code code = new Code();
                    code.setVersionOid(versionOid);
                    this.setField(code, "codeId", scode);
                    ArrayList<Code> list = new ArrayList<Code>();
                    list.add(code);
                    this.setField(basiccode, "code", list);
                } else {
                    log.debug((Object)(versionOid + "@" + scode + " FAIL"));
                    detail.setResultCode("400001");
                }
                response.setBasicCodeResponseDetails(detail);
                response.setResponse(basiccode);
                responses.add(response);
            }
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            log.error((Object)"Fataali virhe koodistotarkistuksessa", (Throwable)ex);
            System.err.println("Fataali virhe koodistotarkistuksessa");
            System.exit(-1);
        }
        log.debug((Object)logHelper.formatMsgEnd(logId));
        log.debug((Object)("responses size: " + responses.size()));
        return responses;
    }

    private boolean validateCodeIn(String logId, String versionOid, String scode) {
        return versionOid != null && !versionOid.isEmpty() && versionOid.contains(".") && scode != null && !scode.isEmpty();
    }

    private void setField(Code code, String fieldName, String scode) throws NoSuchFieldException, IllegalAccessException {
        Field field = code.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(code, scode);
    }

    public boolean isCode(String logId, String key) {
        if (log.isTraceEnabled()) {
            if (codecache.containsKey((Object)key)) {
                log.trace((Object)("cache hit, with key: " + key));
                CacheValueEntry entry = (CacheValueEntry)codecache.get((Object)key);
                if (entry.getValue() != INVALID_CODE) {
                    log.trace((Object)("return true with key: " + key));
                    return true;
                }
                log.trace((Object)("return false with key: " + key));
                return false;
            }
            log.trace((Object)("cache miss with key: " + key));
        }
        if (codecache.containsKey((Object)key)) {
            CacheValueEntry entry = (CacheValueEntry)codecache.get((Object)key);
            return entry.getValue() != INVALID_CODE;
        }
        String koodi = key.split(Pattern.quote("@"))[1];
        String koodistoVersio = key.split(Pattern.quote("@"))[0];
        int i = koodistoVersio.lastIndexOf(46);
        if (i == -1) {
            return false;
        }
        String koodisto = koodistoVersio.substring(0, i);
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)logHelper.formatMsg(logId, "Koodistohaku, koodisto: " + koodisto));
                log.info((Object)logHelper.formatMsg(logId, "Koodistohaku, koodistoVersio: " + koodistoVersio));
                log.info((Object)logHelper.formatMsg(logId, "Koodistohaku, koodi: " + koodi));
            }
            ThlKoodistoClient thlKoodistoClient = new ThlKoodistoClient();
            boolean isActiveCode = thlKoodistoClient.isCodeActive(koodisto, koodistoVersio, koodi, logId);
            if (log.isInfoEnabled()) {
                log.debug((Object)logHelper.formatMsg(logId, "Koodistohaku, isActive: " + isActiveCode));
            }
            if (isActiveCode) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Add to cache, key: " + key + " VALID with current date"));
                }
                codecache.put((Object)key, (Object)new CacheValueEntry(VALID_CODE, new Date()));
                return true;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Add to cache, key: " + key + " INVALID (inactive) with current date"));
            }
            codecache.put((Object)key, (Object)new CacheValueEntry(INVALID_CODE, new Date()));
            return false;
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Add to cache, key: " + key + " INVALID (missing code) with current date"));
            }
            codecache.put((Object)key, (Object)new CacheValueEntry(INVALID_CODE, new Date()));
            log.error((Object)("virhe koodistotarkistuksessa, avaimella: " + key), (Throwable)e);
            log.error((Object)"Koodiston hakuehdot: ");
            log.error((Object)("Koodisto: " + koodisto));
            log.error((Object)("Koodiston versio: " + koodistoVersio));
            log.error((Object)("Koodi: " + koodi));
            return false;
        }
    }

    static {
        cachefile = "cache" + File.separatorChar + "koodistot";
        FetchCodesClient.initcache();
        FetchCodesClient.populatecache();
    }
}

