/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.validation;

import fi.kanta.arkistopalvelu.olddocuments.exception.ErrorWrapperLoader;
import fi.kanta.arkistopalvelu.olddocuments.exception.MessagingException;
import fi.kanta.arkistopalvelu.olddocuments.interfaces.IFetchCodesClient;
import fi.kanta.arkistopalvelu.olddocuments.tasks.LoaderClientProxies;
import fi.kanta.arkistopalvelu.olddocuments.utils.xpathconfig.DctmAttribute;
import fi.kanta.arkistopalvelu.olddocuments.utils.xpathconfig.DctmAttributeForbidden;
import fi.kanta.arkistopalvelu.olddocuments.utils.xpathconfig.DctmAttributesForbidden;
import fi.kanta.arkistopalvelu.webservices.MetadataAttrType;
import fi.kanta.common.components.DateHelper;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCode;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCodeIn;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.BasicCodeResponse;
import fi.kanta.koodistopalvelu.webservices.peruskoodisto.Code;
import fi.kela.kanta.components.XPathHelperVTD;
import fi.kela.kanta.exceptions.XPathHelperVTDException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;

public class AttributeValidator {
    private List<BasicCodeIn> codeSystemValidations;
    private DateHelper dh;
    private Logger log4j = Logger.getLogger(AttributeValidator.class);
    private LogHelper logHelper;
    private ErrorWrapperLoader errorWrapper;
    private Date dateLimit;
    private List<InternalServiceError> errorList = new ArrayList<InternalServiceError>();
    private static final String MAXDATE = "4000/12/31 00:00:00";

    public AttributeValidator() {
        this.codeSystemValidations = new ArrayList<BasicCodeIn>();
        this.dh = new DateHelper();
        this.logHelper = new LogHelper();
        this.errorWrapper = ErrorWrapperLoader.getInstance();
        this.dateLimit = this.getDate(4000, 12, 31);
    }

    private Date getDate(int year, int month, int date) {
        Calendar working = GregorianCalendar.getInstance();
        working.set(year, month, date, 0, 0, 0);
        return working.getTime();
    }

    public String validate(String logId, String attrValue, DctmAttribute attr) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (attr.isIsNodelist()) {
            InternalServiceError error = this.errorWrapper.getError("0010");
            error.setErrorDescription("Attribuutti on nodelist, mutta annettiin yksiarvoiseen validointiin");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        String attrStr = this.validateAttr(logId, attrValue, attr);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return attrStr;
    }

    private String validateAttr(String logId, String attrValue, DctmAttribute attr) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String value = attrValue;
        this.validateMinLength(logId, attrValue, attr);
        this.validateMaxLength(logId, attrValue, attr);
        if (MetadataAttrType.II.name().equals(attr.getDctmAttributeType())) {
            this.validateII(logId, attrValue, attr);
        } else if (MetadataAttrType.CV.name().equals(attr.getDctmAttributeType())) {
            this.validateCV(logId, attrValue, attr);
            this.addCVCodesystemValidation(logId, attrValue, attr);
        } else if (MetadataAttrType.T.name().equals(attr.getDctmAttributeType())) {
            value = this.validateT(logId, attrValue, attr);
        } else if (MetadataAttrType.S.name().equals(attr.getDctmAttributeType())) {
            this.addSCodesystemValidation(logId, attrValue, attr);
        } else if (MetadataAttrType.BL.name().equals(attr.getDctmAttributeType())) {
            this.validateBL(logId, attrValue, attr);
        } else if (MetadataAttrType.I.name().equals(attr.getDctmAttributeType()) || MetadataAttrType.IVL.name().equals(attr.getDctmAttributeType())) {
            // empty if block
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return value;
    }

    public String validate(String logId, List<String> attrValue, DctmAttribute attr, String separator) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (!attr.isIsNodelist()) {
            InternalServiceError error = this.errorWrapper.getError("0010");
            error.setErrorDescription("Listan validointia kutsuttiin attribuutille, joka ei ole nodelist");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        StringBuilder finalString = new StringBuilder();
        if (!attrValue.isEmpty()) {
            for (String singleValue : attrValue) {
                this.validateAttr(logId, singleValue, attr);
                finalString.append(singleValue);
                finalString.append(separator);
            }
        } else {
            this.validateAttr(logId, finalString.toString(), attr);
        }
        String val = finalString.toString();
        if (MetadataAttrType.S.name().equals(attr.getDctmAttributeType())) {
            val = val.trim();
        }
        if (val.length() > attr.getAttributeMaxLengthTotal().intValue()) {
            InternalServiceError error = this.errorWrapper.getError("0010");
            error.setErrorDescription("Nodelistin kokonaisuuspituus ylitti suurimman sallitun");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return val;
    }

    private String validateT(String logId, String attrValue, DctmAttribute attr) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String date = "";
        Date compareDate = null;
        try {
            date = this.dh.toOracleLongDate(logId, attrValue);
            compareDate = this.dh.toDate(logId, attrValue);
        }
        catch (UtilException e) {
            InternalServiceError error = this.errorWrapper.getError("0010");
            error.setErrorDescription("T tyyppinen attribuutti virheellinen " + attr.getDctmAttributeXpath());
            this.log4j.error((Object)this.logHelper.formatMsg(logId, e.getInternalServiceError()), (Throwable)e);
            this.errorList.add(error);
        }
        if (compareDate != null && compareDate.after(this.dateLimit)) {
            date = MAXDATE;
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return date;
    }

    private void validateBL(String logId, String attrValue, DctmAttribute attr) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (!"true".equals(attrValue) && !"false".equals(attrValue)) {
            InternalServiceError error = this.errorWrapper.getError("0010");
            error.setErrorDescription("BL tyyppinen attribuutti virheellinen " + attr.getDctmAttributeXpath());
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validateCV(String logId, String attrValue, DctmAttribute attr) {
    }

    private void validateII(String logId, String attrValue, DctmAttribute attr) {
    }

    private void addCVCodesystemValidation(String logId, String attrValue, DctmAttribute attr) {
        List<String> allowedCodeSystemList;
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if ((allowedCodeSystemList = attr.getCodesystemCheck()) != null && !allowedCodeSystemList.isEmpty()) {
            String[] split = attrValue.split("!");
            if (split.length == 2 && allowedCodeSystemList.contains(split[0])) {
                BasicCodeIn codeIn = new BasicCodeIn();
                codeIn.setLanguage("fi");
                codeIn.setVersionoid(split[0]);
                codeIn.setCodeid(split[1]);
                this.codeSystemValidations.add(codeIn);
            } else {
                InternalServiceError error = this.errorWrapper.getError("0010");
                error.setErrorDescription("Tunnistamaton koodisto attribuutissa [" + attr.getName() + "]: [" + attrValue + "]");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                this.errorList.add(error);
            }
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void addSCodesystemValidation(String logId, String attrValue, DctmAttribute attr) {
        List<String> allowedCodeSystemList;
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (!(allowedCodeSystemList = attr.getCodesystemCheck()).isEmpty()) {
            BasicCodeIn codeIn = new BasicCodeIn();
            codeIn.setLanguage("fi");
            codeIn.setVersionoid(allowedCodeSystemList.get(0));
            codeIn.setCodeid(attrValue);
            this.codeSystemValidations.add(codeIn);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public void validateCodesystems(String logId, boolean checkCodes) throws MessagingException, InterruptedException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (this.codeSystemValidations != null && !this.codeSystemValidations.isEmpty() && checkCodes) {
            List<BasicCodeResponse> responses = this.getCodes(logId);
            this.checkBasicCodeResponse(logId, this.codeSystemValidations, responses);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validateMinLength(String logId, String attrValue, DctmAttribute attr) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (!(attr.getAttributeMinLength().equals(BigInteger.ZERO) || attrValue != null && attr.getAttributeMinLength().intValue() <= attrValue.length())) {
            InternalServiceError error = this.errorWrapper.getError("0010");
            error.setErrorDescription("Attribuutin arvo liian lyhyt " + attr.getName());
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validateMaxLength(String logId, String attrValue, DctmAttribute attr) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (attrValue != null && attr.getAttributeMaxLength().intValue() < attrValue.length()) {
            InternalServiceError error = this.errorWrapper.getError("0010");
            error.setErrorDescription("Attribuutin arvo liian pitk\u00e4 " + attr.getName());
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void checkBasicCodeResponse(String logId, List<BasicCodeIn> codeInList, List<BasicCodeResponse> responses) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (responses != null) {
            if (responses.isEmpty()) {
                InternalServiceError error = this.errorWrapper.getError("0010");
                error.setErrorDescription("Koodia ei saatu koodistosta, ei vastauksia koodistosta ");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                this.errorList.add(error);
            }
            for (int i = 0; i < responses.size(); ++i) {
                List code;
                String codeId;
                InternalServiceError error;
                BasicCodeResponse response = responses.get(i);
                BasicCode basicCode = response.getResponse();
                if (basicCode == null) {
                    error = this.errorWrapper.getError("0010");
                    BasicCodeIn codeIn = codeInList.get(i);
                    String codeStr = String.format("Haettu arvoilla (Koodisto,koodi,kielitunniste): %s,%s,%s", codeIn.getVersionoid(), codeIn.getCodeid(), codeIn.getLanguage());
                    error.setErrorMessage("Koodia ei saatu koodistosta");
                    error.setErrorDescription("Koodia ei saatu koodistosta, desc: " + codeStr);
                    this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                    this.log4j.error((Object)("ERROR: " + response.getBasicCodeResponseDetails().getDescription() + ", " + response.getBasicCodeResponseDetails().getResultCode()));
                    this.errorList.add(error);
                }
                if (!(basicCode == null || basicCode.getCode() == null || basicCode.getCode().isEmpty() || (codeId = ((Code)(code = basicCode.getCode()).get(0)).getCodeId()) != null && codeId.length() != 0)) {
                    InternalServiceError error2 = this.errorWrapper.getError("0010");
                    error2.setErrorDescription("Koodia ei saatu koodistosta");
                    this.log4j.error((Object)this.logHelper.formatMsg(logId, error2));
                    this.errorList.add(error2);
                }
                if (response.getBasicCodeResponseDetails().getResultCode().equals("400000")) continue;
                error = this.errorWrapper.getError("0010");
                error.setErrorDescription("Koodia ei saatu koodistosta ");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                this.errorList.add(error);
            }
        } else {
            InternalServiceError error = this.errorWrapper.getError("0010");
            error.setErrorDescription("Koodia ei saatu koodistosta ");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<BasicCodeResponse> getCodes(String logId) throws MessagingException, InterruptedException {
        List<BasicCodeResponse> resp;
        block7: {
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
            }
            resp = null;
            ArrayList<BasicCodeIn> checkCodes = new ArrayList<BasicCodeIn>();
            for (BasicCodeIn basicCodeIn : this.codeSystemValidations) {
                checkCodes.add(basicCodeIn);
            }
            if (checkCodes.isEmpty()) break block7;
            IFetchCodesClient client = null;
            try {
                this.log4j.debug((Object)"START codecheck");
                client = LoaderClientProxies.getKoodistoClient().getCodeProxy();
                resp = client.execute(logId, checkCodes);
                this.log4j.debug((Object)"END codecheck");
            }
            catch (InterruptedException interruptedException) {
                LoaderClientProxies.getKoodistoClient().releaseCodeProxy(client);
                catch (Throwable throwable) {
                    LoaderClientProxies.getKoodistoClient().releaseCodeProxy(client);
                    throw throwable;
                }
            }
            LoaderClientProxies.getKoodistoClient().releaseCodeProxy(client);
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        return resp;
    }

    public void checkForbiddenMetadata(String logId, XPathHelperVTD xpathHelperVTD, DctmAttributesForbidden dctmAttributesForbidden) throws XPathHelperVTDException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String val = null;
        for (DctmAttributeForbidden dctmAttr : dctmAttributesForbidden.getDctmAttributeForbidden()) {
            try {
                val = xpathHelperVTD.getAsString(dctmAttr.getDctmAttributeXpath());
            }
            catch (IndexOutOfBoundsException e) {
                this.log4j.info((Object)("virhe pathissa: " + dctmAttr.getDctmAttributeXpath()));
                val = xpathHelperVTD.getCode(dctmAttr.getDctmAttributeXpath());
                this.log4j.info((Object)("getCode palautti: '" + val + "'"));
            }
            if (val == null || val.trim().length() <= 0) continue;
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)("Kielletyn elementin xpath: " + dctmAttr.getDctmAttributeXpath()));
            }
            InternalServiceError error = this.errorWrapper.getError("0004");
            error.setErrorDescription("Asiakirja sis\u00e4lsi kielletyn elementin: " + dctmAttr.getName());
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public List<InternalServiceError> getErrorList() {
        return this.errorList;
    }
}

