/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer.gf.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.verapdf.tools.TypeConverter;
import org.verapdf.xmp.XMPDateTime;
import org.verapdf.xmp.XMPDateTimeFactory;
import org.verapdf.xmp.XMPException;

public class DateConverter {
    public static String toXMPDateFormat(Calendar calendar) {
        return calendar == null ? null : DateConverter.toXMPDateFormat(calendar.getTime());
    }

    public static String toXMPDateFormat(Date time) {
        if (time == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").format(time);
    }

    public static String toXMPDateFormat(String date) {
        return DateConverter.toXMPDateFormat(DateConverter.toCalendar(date));
    }

    public static Calendar toCalendar(String date) {
        if (date == null) {
            return null;
        }
        return TypeConverter.parseDate((String)date);
    }

    public static String toPDFDateFormat(String date) {
        try {
            XMPDateTime fromISO8601 = XMPDateTimeFactory.createFromISO8601((String)date);
            Calendar buffer = fromISO8601.getCalendar();
            return TypeConverter.getPDFDate((Calendar)buffer);
        }
        catch (XMPException e) {
            throw new IllegalStateException("Problems with parsing utc date", e);
        }
    }

    public static String toPDFDateFormat(Calendar date) {
        return TypeConverter.getPDFDate((Calendar)date);
    }
}

