/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.xref;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.cos.COSKey;

public class COSXRefTable {
    private List<COSKey> all = new ArrayList<COSKey>();
    private int maxKeyNumber = 0;

    public void set(List<COSKey> keys) {
        this.all = keys;
        this.maxKeyNumber = keys.stream().map(COSKey::getNumber).max(Integer::compare).orElse(0);
    }

    private int getGreatestKeyNumberFromXref() {
        return this.maxKeyNumber;
    }

    public COSKey next() {
        return new COSKey(this.getGreatestKeyNumberFromXref() + 1);
    }

    public void newKey(COSKey key) {
        this.all.add(key);
        if (key.getNumber() > this.maxKeyNumber) {
            this.maxKeyNumber = key.getNumber();
        }
    }

    public void newKey(List<COSKey> key) {
        this.all.addAll(key);
        int newKeysMaxKeyNumber = key.stream().map(COSKey::getNumber).max(Integer::compare).orElse(0);
        if (newKeysMaxKeyNumber > this.maxKeyNumber) {
            this.maxKeyNumber = newKeysMaxKeyNumber;
        }
    }

    public List<COSKey> getAllKeys() {
        return this.all;
    }
}

