/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.core.utils;

import java.io.File;
import java.nio.file.Path;
import org.verapdf.core.VeraPDFException;
import org.verapdf.core.utils.AbstractFileOutputMapper;

final class RelativeDirectoryMapper
extends AbstractFileOutputMapper {
    static final String defaultRelativePath = ".";
    private static final RelativeDirectoryMapper defaultInstance = new RelativeDirectoryMapper();
    private final String relDirPath;

    private RelativeDirectoryMapper() {
        this(defaultRelativePath);
    }

    private RelativeDirectoryMapper(String relativePath) {
        this(relativePath, "veraPDF_");
    }

    private RelativeDirectoryMapper(String relativePath, String prefix) {
        this(relativePath, prefix, "");
    }

    private RelativeDirectoryMapper(String relativePath, String prefix, String suffix) {
        super(prefix, suffix);
        this.relDirPath = relativePath;
    }

    @Override
    protected File doMapFile(File orig) throws VeraPDFException {
        String newName = RelativeDirectoryMapper.addPrefixAndSuffix(orig, this);
        return RelativeDirectoryMapper.makeNewFile(orig, this.relDirPath, newName);
    }

    @Override
    public String toString() {
        return "RelativeDirectoryMapper [prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ",relDirPath=" + this.relDirPath + "]";
    }

    private static File makeNewFile(File orig, String relPath, String newName) throws VeraPDFException {
        Path parentPath;
        Path resolvedPath;
        File parent = orig.getParentFile();
        if (!(relPath.equals(defaultRelativePath) || (parent = (resolvedPath = (parentPath = parent.toPath()).resolve(relPath)).toFile()).exists() || parent.mkdirs())) {
            throw new VeraPDFException("Cannot create directory: " + parent);
        }
        return new File(parent, newName);
    }

    static final RelativeDirectoryMapper defaultInstance() {
        return defaultInstance;
    }

    static final RelativeDirectoryMapper withPrefixAndSuffix(String prefix, String suffix) {
        return new RelativeDirectoryMapper(defaultRelativePath, prefix, suffix);
    }

    static final RelativeDirectoryMapper fromValues(String relativePath, String prefix, String suffix) {
        return new RelativeDirectoryMapper(relativePath, prefix, suffix);
    }
}

