/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.SignatureFeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.SignatureFeaturesObjectAdapter;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class SignatureFeaturesObject
extends FeaturesObject {
    private static final String SIGNATURE = "signature";
    private static final String FILTER = "filter";
    private static final String SUB_FILTER = "subFilter";
    private static final String CONTENTS = "contents";
    private static final String NAME = "name";
    private static final String SIGN_DATE = "signDate";
    private static final String LOCATION = "location";
    private static final String REASON = "reason";
    private static final String CONTACT_INFO = "contactInfo";

    public SignatureFeaturesObject(SignatureFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.SIGNATURE;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        SignatureFeaturesObjectAdapter signAdapter = (SignatureFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(SIGNATURE);
        CreateNodeHelper.addNotEmptyNode(FILTER, signAdapter.getFilter(), root);
        CreateNodeHelper.addNotEmptyNode(SUB_FILTER, signAdapter.getSubFilter(), root);
        CreateNodeHelper.addNotEmptyNode(CONTENTS, signAdapter.getHexContents(), root);
        CreateNodeHelper.addNotEmptyNode(NAME, signAdapter.getName(), root);
        CreateNodeHelper.createDateNode(SIGN_DATE, root, signAdapter.getSignDate(), this);
        CreateNodeHelper.addNotEmptyNode(LOCATION, signAdapter.getLocation(), root);
        CreateNodeHelper.addNotEmptyNode(REASON, signAdapter.getReason(), root);
        CreateNodeHelper.addNotEmptyNode(CONTACT_INFO, signAdapter.getContactInfo(), root);
        return root;
    }

    @Override
    public FeaturesData getData() {
        SignatureFeaturesObjectAdapter signAdapter = (SignatureFeaturesObjectAdapter)this.adapter;
        InputStream stream = signAdapter.getData();
        return SignatureFeaturesData.newInstance(stream, signAdapter.getFilter(), signAdapter.getSubFilter(), signAdapter.getName(), signAdapter.getSignDate(), signAdapter.getLocation(), signAdapter.getReason(), signAdapter.getContactInfo());
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Filter", SignatureFeaturesObject.generateVariableXPath(SIGNATURE, FILTER), Feature.FeatureType.STRING));
        featuresList.add(new Feature("SubFilter", SignatureFeaturesObject.generateVariableXPath(SIGNATURE, SUB_FILTER), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Contents", SignatureFeaturesObject.generateVariableXPath(SIGNATURE, CONTENTS), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Name", SignatureFeaturesObject.generateVariableXPath(SIGNATURE, NAME), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Sign Date", SignatureFeaturesObject.generateVariableXPath(SIGNATURE, SIGN_DATE), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Location", SignatureFeaturesObject.generateVariableXPath(SIGNATURE, LOCATION), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Reason", SignatureFeaturesObject.generateVariableXPath(SIGNATURE, REASON), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Contact Info", SignatureFeaturesObject.generateVariableXPath(SIGNATURE, CONTACT_INFO), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Error IDs", SignatureFeaturesObject.generateAttributeXPath(SIGNATURE, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

