/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.ComponentDetails;
import org.verapdf.core.VeraPDFException;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.BatchProcessor;
import org.verapdf.processor.ItemProcessor;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.ItemDetails;

public abstract class AbstractBatchProcessor
implements BatchProcessor {
    protected final ItemProcessor processor;
    private BatchProcessingHandler handler = null;
    private ProcessorFactory.BatchSummariser summariser = null;

    protected AbstractBatchProcessor(ItemProcessor processor) {
        this.processor = processor;
    }

    @Override
    public ProcessorConfig getConfig() {
        return this.processor.getConfig();
    }

    @Override
    public Collection<ReleaseDetails> getDependencies() {
        return this.processor.getDependencies();
    }

    @Override
    public ComponentDetails getDetails() {
        return this.processor.getDetails();
    }

    @Override
    public void close() throws IOException {
        this.processor.close();
    }

    @Override
    public BatchSummary process(File toProcess, boolean recurse, BatchProcessingHandler resultHandler) throws VeraPDFException {
        this.initialise(resultHandler);
        this.handler.handleBatchStart(this.processor.getConfig());
        this.processContainer(toProcess, recurse);
        return this.finishBatch();
    }

    @Override
    public BatchSummary process(List<? extends File> toProcess, BatchProcessingHandler resultHandler) throws VeraPDFException {
        this.initialise(resultHandler);
        this.handler.handleBatchStart(this.processor.getConfig());
        this.processList(toProcess);
        return this.finishBatch();
    }

    @Override
    public BatchSummary process(ItemDetails itemDetails, InputStream stream, BatchProcessingHandler resultHandler) throws VeraPDFException {
        this.initialise(resultHandler);
        this.handler.handleBatchStart(this.processor.getConfig());
        this.process(itemDetails, stream);
        return this.finishBatch();
    }

    protected abstract void processContainer(File var1, boolean var2) throws VeraPDFException;

    protected abstract void processList(List<? extends File> var1) throws VeraPDFException;

    protected abstract void process(ItemDetails var1, InputStream var2) throws VeraPDFException;

    private void initialise(BatchProcessingHandler resultHandler) {
        this.summariser = new ProcessorFactory.BatchSummariser(this.getConfig());
        this.handler = resultHandler;
    }

    protected void processResult(ProcessorResult result, Boolean isLogsEnabled) throws VeraPDFException {
        this.handler.handleResult(result, isLogsEnabled);
        this.summariser.addProcessingResult(result);
    }

    private BatchSummary finishBatch() throws VeraPDFException {
        BatchSummary summary = this.summariser.summarise();
        this.handler.handleBatchEnd(summary);
        return summary;
    }
}

