/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.constantPool;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.constantPool.Item;
import mockit.asm.types.JavaType;

public class TypeOrMemberItem
extends Item {
    @Nonnull
    String name;
    @Nonnull
    String desc;
    @Nonnegative
    private int argSize;

    TypeOrMemberItem(@Nonnegative int index) {
        super(index);
        this.desc = "";
        this.name = "";
    }

    TypeOrMemberItem(@Nonnegative int index, @Nonnull TypeOrMemberItem item) {
        super(index, item);
        this.name = item.name;
        this.desc = item.desc;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getDesc() {
        return this.desc;
    }

    final void setValuesAndHashcode(@Nonnull String name, @Nonnull String desc, @Nonnegative int hashCodeMultiplier) {
        this.name = name;
        this.desc = desc;
        this.setHashCode(hashCodeMultiplier * name.hashCode() * desc.hashCode());
    }

    @Override
    boolean isEqualTo(@Nonnull Item item) {
        return this.isEqualTo((TypeOrMemberItem)item);
    }

    final boolean isEqualTo(@Nonnull TypeOrMemberItem item) {
        return item.name.equals(this.name) && item.desc.equals(this.desc);
    }

    @Nonnegative
    public final int getArgSizeComputingIfNeeded(@Nonnull String methodDesc) {
        int thisArgSize = this.argSize;
        if (thisArgSize == 0) {
            this.argSize = thisArgSize = JavaType.getArgumentsAndReturnSizes(methodDesc);
        }
        return thisArgSize;
    }
}

