/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.methods;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.constantPool.AttributeWriter;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.controlFlow.Label;
import mockit.asm.util.ByteVector;

final class LocalVariableTableWriter
extends AttributeWriter {
    @Nonnegative
    private int localVarCount;
    @Nullable
    private ByteVector localVarTable;
    @Nonnegative
    private int localVarTypeAttributeIndex;
    @Nonnegative
    private int localVarTypeCount;
    @Nullable
    private ByteVector localVarTypeTable;

    LocalVariableTableWriter(@Nonnull ConstantPoolGeneration cp) {
        super(cp);
    }

    @Nonnegative
    int addLocalVariable(@Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nonnull Label start, @Nonnull Label end, @Nonnegative int index) {
        if (signature != null) {
            if (this.localVarTypeTable == null) {
                this.localVarTypeAttributeIndex = this.cp.newUTF8("LocalVariableTypeTable");
                this.localVarTypeTable = new ByteVector();
            }
            this.addAttribute(this.localVarTypeTable, name, signature, start, end, index);
            ++this.localVarTypeCount;
        }
        if (this.localVarTable == null) {
            this.setAttribute("LocalVariableTable");
            this.localVarTable = new ByteVector();
        }
        this.addAttribute(this.localVarTable, name, desc, start, end, index);
        ++this.localVarCount;
        char c = desc.charAt(0);
        int n = index + (c == 'J' || c == 'D' ? 2 : 1);
        return n;
    }

    private void addAttribute(@Nonnull ByteVector attribute, @Nonnull String name, @Nonnull String desc, @Nonnull Label start, @Nonnull Label end, @Nonnegative int index) {
        attribute.putShort(start.position).putShort(end.position - start.position).putShort(this.cp.newUTF8(name)).putShort(this.cp.newUTF8(desc)).putShort(index);
    }

    @Override
    @Nonnegative
    public int getSize() {
        return LocalVariableTableWriter.getSize(this.localVarTable) + LocalVariableTableWriter.getSize(this.localVarTypeTable);
    }

    @Nonnegative
    private static int getSize(@Nullable ByteVector attribute) {
        return attribute == null ? 0 : 8 + attribute.getLength();
    }

    @Nonnegative
    int getAttributeCount() {
        return (this.localVarTable == null ? 0 : 1) + (this.localVarTypeTable == null ? 0 : 1);
    }

    @Override
    public void put(@Nonnull ByteVector out) {
        this.put(out, this.localVarTable, this.localVarCount);
        this.attributeIndex = this.localVarTypeAttributeIndex;
        this.put(out, this.localVarTypeTable, this.localVarTypeCount);
    }

    private void put(@Nonnull ByteVector out, @Nullable ByteVector attribute, @Nonnegative int numEntries) {
        if (attribute != null) {
            this.put(out, 2 + attribute.getLength());
            out.putShort(numEntries);
            out.putByteVector(attribute);
        }
    }
}

