/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.types;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.types.JavaType;
import mockit.asm.types.ReferenceType;

public final class ArrayType
extends ReferenceType {
    @Nonnull
    public static ArrayType create(@Nonnull String typeDesc) {
        return new ArrayType(typeDesc.toCharArray());
    }

    @Nonnull
    static ArrayType create(@Nonnull char[] typeDesc, @Nonnegative int off) {
        int len = ArrayType.findNumberOfDimensions(typeDesc, off);
        if (typeDesc[off + len] == 'L') {
            len = ArrayType.findTypeNameLength(typeDesc, off, len);
        }
        return new ArrayType(typeDesc, off, len + 1);
    }

    @Nonnegative
    private static int findNumberOfDimensions(@Nonnull char[] typeDesc, @Nonnegative int off) {
        int dimensions = 1;
        while (typeDesc[off + dimensions] == '[') {
            ++dimensions;
        }
        return dimensions;
    }

    private ArrayType(@Nonnull char[] typeDesc, @Nonnegative int off, @Nonnegative int len) {
        super(typeDesc, off, len);
    }

    ArrayType(@Nonnull char[] typeDesc) {
        super(typeDesc);
    }

    @Nonnegative
    public int getDimensions() {
        return ArrayType.findNumberOfDimensions(this.typeDescChars, this.off);
    }

    @Nonnull
    public JavaType getElementType() {
        int dimensions = this.getDimensions();
        return ArrayType.getType(this.typeDescChars, this.off + dimensions);
    }

    @Override
    @Nonnull
    public String getClassName() {
        int dimensions;
        String className = this.getElementType().getClassName();
        StringBuilder sb = new StringBuilder(className);
        for (int i = dimensions = this.getDimensions(); i > 0; --i) {
            sb.append("[]");
        }
        return sb.toString();
    }
}

