/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.annotations.AnnotationVisitor;
import mockit.asm.controlFlow.Label;
import mockit.asm.methods.MethodWriter;
import mockit.asm.methods.WrappingMethodVisitor;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.lines.PerFileLineCoverage;
import mockit.coverage.modification.CFGTracking;
import mockit.coverage.modification.VisitInterruptedException;

final class MethodModifier
extends WrappingMethodVisitor {
    private static final String DATA_RECORDING_CLASS = "mockit/coverage/TestRun";
    @Nonnull
    private final String sourceFileName;
    @Nonnull
    private final FileCoverageData fileData;
    @Nonnull
    private final PerFileLineCoverage lineCoverageInfo;
    @Nonnull
    private final CFGTracking cfgTracking;
    private boolean foundInterestingInstruction;
    @Nonnegative
    int currentLine;

    MethodModifier(@Nonnull MethodWriter mw, @Nonnull String sourceFileName, @Nonnull FileCoverageData fileData) {
        super(mw);
        this.sourceFileName = sourceFileName;
        this.fileData = fileData;
        this.lineCoverageInfo = fileData.getLineCoverageData();
        this.cfgTracking = new CFGTracking(this.lineCoverageInfo);
    }

    @Override
    public AnnotationVisitor visitAnnotation(@Nonnull String desc) {
        boolean isTestMethod;
        boolean bl = isTestMethod = desc.startsWith("Lorg/junit/") || desc.startsWith("Lorg/testng/");
        if (isTestMethod) {
            throw VisitInterruptedException.INSTANCE;
        }
        return this.mw.visitAnnotation(desc);
    }

    @Override
    public void visitLineNumber(@Nonnegative int line, @Nonnull Label start) {
        this.lineCoverageInfo.addLine(line);
        this.currentLine = line;
        this.cfgTracking.startNewLine();
        this.generateCallToRegisterLineExecution();
        this.mw.visitLineNumber(line, start);
    }

    private void generateCallToRegisterLineExecution() {
        this.mw.visitIntInsn(17, this.fileData.index);
        this.pushCurrentLineOnTheStack();
        this.mw.visitMethodInsn(184, DATA_RECORDING_CLASS, "lineExecuted", "(II)V", false);
    }

    private void pushCurrentLineOnTheStack() {
        if (this.currentLine <= Short.MAX_VALUE) {
            this.mw.visitIntInsn(17, this.currentLine);
        } else {
            this.mw.visitLdcInsn(this.currentLine);
        }
    }

    @Override
    public void visitLabel(@Nonnull Label label) {
        this.mw.visitLabel(label);
        this.cfgTracking.afterNewLabel(this.currentLine, label);
    }

    @Override
    public void visitJumpInsn(@Nonnegative int opcode, @Nonnull Label label) {
        Label jumpSource = this.mw.getCurrentBlock();
        assert (jumpSource != null);
        this.mw.visitJumpInsn(opcode, label);
        if (opcode == 167) {
            this.cfgTracking.afterGoto();
        } else {
            this.cfgTracking.afterConditionalJump(this, jumpSource, label);
        }
    }

    private void generateCallToRegisterBranchTargetExecutionIfPending() {
        this.cfgTracking.generateCallToRegisterBranchTargetExecutionIfPending(this);
    }

    void generateCallToRegisterBranchTargetExecution(@Nonnegative int branchIndex) {
        this.mw.visitIntInsn(17, this.fileData.index);
        this.pushCurrentLineOnTheStack();
        this.mw.visitIntInsn(17, branchIndex);
        this.mw.visitMethodInsn(184, DATA_RECORDING_CLASS, "branchExecuted", "(III)V", false);
    }

    @Override
    public void visitInsn(@Nonnegative int opcode) {
        boolean isReturn;
        boolean bl = isReturn = opcode >= 172 && opcode <= 177;
        if (!isReturn && !MethodModifier.isDefaultReturnValue(opcode)) {
            this.foundInterestingInstruction = true;
        }
        if (isReturn && !this.foundInterestingInstruction && this.cfgTracking.hasOnlyOneLabelBeingVisited()) {
            this.lineCoverageInfo.getOrCreateLineData(this.currentLine).markAsUnreachable();
        } else {
            this.cfgTracking.beforeNoOperandInstruction(this, opcode);
        }
        this.mw.visitInsn(opcode);
    }

    private static boolean isDefaultReturnValue(@Nonnegative int opcode) {
        return opcode == 1 || opcode == 3 || opcode == 9 || opcode == 11 || opcode == 14;
    }

    @Override
    public void visitIntInsn(@Nonnegative int opcode, int operand) {
        this.foundInterestingInstruction = true;
        this.generateCallToRegisterBranchTargetExecutionIfPending();
        this.mw.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitVarInsn(@Nonnegative int opcode, @Nonnegative int varIndex) {
        this.generateCallToRegisterBranchTargetExecutionIfPending();
        this.mw.visitVarInsn(opcode, varIndex);
    }

    @Override
    public void visitTypeInsn(@Nonnegative int opcode, @Nonnull String typeDesc) {
        this.generateCallToRegisterBranchTargetExecutionIfPending();
        this.mw.visitTypeInsn(opcode, typeDesc);
    }

    @Override
    public void visitFieldInsn(@Nonnegative int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
        boolean getField = opcode == 178 || opcode == 180;
        boolean isStatic = opcode == 179 || opcode == 178;
        char fieldType = desc.charAt(0);
        boolean size2 = fieldType == 'J' || fieldType == 'D';
        String classAndFieldNames = null;
        boolean fieldHasData = false;
        if (!owner.startsWith("java/") && (fieldHasData = this.fileData.dataCoverageInfo.isFieldWithCoverageData(classAndFieldNames = owner.substring(owner.lastIndexOf(47) + 1) + '.' + name)) && !isStatic) {
            this.generateCodeToSaveInstanceReferenceOnTheStack(getField, size2);
        }
        this.generateCallToRegisterBranchTargetExecutionIfPending();
        this.mw.visitFieldInsn(opcode, owner, name, desc);
        if (opcode == 178 && "$assertionsDisabled".equals(name)) {
            this.cfgTracking.registerAssertFoundInCurrentLine();
        }
        this.cfgTracking.registerFindingPotentialAssertFalse();
        if (fieldHasData) {
            this.generateCallToRegisterFieldCoverage(getField, isStatic, size2, classAndFieldNames);
        }
    }

    private void generateCodeToSaveInstanceReferenceOnTheStack(boolean getField, boolean size2) {
        if (getField) {
            this.mw.visitInsn(89);
        } else if (size2) {
            this.mw.visitInsn(93);
            this.mw.visitInsn(88);
            this.mw.visitInsn(91);
            this.mw.visitInsn(91);
            this.mw.visitInsn(87);
        } else {
            this.mw.visitInsn(90);
            this.mw.visitInsn(87);
            this.mw.visitInsn(90);
            this.mw.visitInsn(90);
            this.mw.visitInsn(87);
        }
    }

    private void generateCallToRegisterFieldCoverage(boolean getField, boolean isStatic, boolean size2, @Nonnull String classAndFieldNames) {
        if (!isStatic && getField) {
            if (size2) {
                this.mw.visitInsn(93);
                this.mw.visitInsn(88);
            } else {
                this.mw.visitInsn(90);
                this.mw.visitInsn(87);
            }
        }
        this.mw.visitLdcInsn(this.sourceFileName);
        this.mw.visitLdcInsn(classAndFieldNames);
        String methodToCall = getField ? "fieldRead" : "fieldAssigned";
        String methodDesc = isStatic ? "(Ljava/lang/String;Ljava/lang/String;)V" : "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V";
        this.mw.visitMethodInsn(184, DATA_RECORDING_CLASS, methodToCall, methodDesc, false);
    }

    @Override
    public void visitMethodInsn(@Nonnegative int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
        if (opcode == 182 && "java/lang/Class".equals(owner) && "desiredAssertionStatus".equals(name)) {
            this.cfgTracking.registerAssertFoundInCurrentLine();
        }
        if (opcode != 183 || !"()V".equals(desc)) {
            this.foundInterestingInstruction = true;
        }
        this.generateCallToRegisterBranchTargetExecutionIfPending();
        this.mw.visitMethodInsn(opcode, owner, name, desc, itf);
        this.cfgTracking.afterMethodInstruction(opcode, owner, name);
    }

    @Override
    public void visitLdcInsn(@Nonnull Object cst) {
        this.foundInterestingInstruction = true;
        this.generateCallToRegisterBranchTargetExecutionIfPending();
        this.mw.visitLdcInsn(cst);
    }

    @Override
    public void visitIincInsn(@Nonnegative int varIndex, int increment) {
        this.generateCallToRegisterBranchTargetExecutionIfPending();
        this.mw.visitIincInsn(varIndex, increment);
    }

    @Override
    public void visitTryCatchBlock(@Nonnull Label start, @Nonnull Label end, @Nonnull Label handler, @Nullable String type) {
        this.generateCallToRegisterBranchTargetExecutionIfPending();
        this.mw.visitTryCatchBlock(start, end, handler, type);
    }

    @Override
    public void visitLookupSwitchInsn(@Nonnull Label dflt, @Nonnull int[] keys, @Nonnull Label[] labels) {
        this.cfgTracking.beforeLookupSwitchInstruction();
        this.generateCallToRegisterBranchTargetExecutionIfPending();
        this.mw.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitTableSwitchInsn(@Nonnegative int min, @Nonnegative int max, @Nonnull Label dflt, Label ... labels) {
        this.generateCallToRegisterBranchTargetExecutionIfPending();
        this.mw.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(@Nonnull String desc, @Nonnegative int dims) {
        this.generateCallToRegisterBranchTargetExecutionIfPending();
        this.mw.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitMaxStack(@Nonnegative int maxStack) {
        if (maxStack > 1) {
            this.lineCoverageInfo.markLineAsReachable(this.currentLine);
        }
        this.mw.visitMaxStack(maxStack);
    }
}

