/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.List;
import javax.annotation.Nonnull;
import mockit.internal.util.Utilities;

final class PartiallyMockedInstances {
    @Nonnull
    private final List<?> dynamicMockInstancesToMatch;

    PartiallyMockedInstances(@Nonnull List<?> dynamicMockInstancesToMatch) {
        this.dynamicMockInstancesToMatch = dynamicMockInstancesToMatch;
    }

    boolean isToBeMatchedOnInstance(@Nonnull Object mock) {
        return Utilities.containsReference(this.dynamicMockInstancesToMatch, mock);
    }

    boolean isDynamicMockInstanceOrClass(@Nonnull Object invokedInstance, @Nonnull Object invocationInstance) {
        if (Utilities.containsReference(this.dynamicMockInstancesToMatch, invokedInstance)) {
            return true;
        }
        Class<?> invokedClass = invocationInstance.getClass();
        for (Object dynamicMock : this.dynamicMockInstancesToMatch) {
            if (dynamicMock.getClass() != invokedClass) continue;
            return true;
        }
        return false;
    }
}

