/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.faking;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.faking.FakeInvocation;
import mockit.internal.faking.FakeMethods;
import mockit.internal.reflection.MethodReflection;
import mockit.internal.reflection.RealMethodOrConstructor;
import mockit.internal.util.ClassLoad;

final class FakeState {
    private static final ClassLoader THIS_CL = FakeState.class.getClassLoader();
    @Nonnull
    final FakeMethods.FakeMethod fakeMethod;
    @Nullable
    private Method actualFakeMethod;
    @Nullable
    private Member realMethodOrConstructor;
    @Nullable
    private Object realClass;
    private int invocationCount;
    @Nullable
    private ThreadLocal<FakeInvocation> proceedingInvocation;
    @Nonnull
    private final Object invocationCountLock;

    FakeState(@Nonnull FakeMethods.FakeMethod fakeMethod) {
        this.fakeMethod = fakeMethod;
        this.invocationCountLock = new Object();
        if (fakeMethod.canBeReentered()) {
            this.makeReentrant();
        }
    }

    @Nonnull
    Class<?> getRealClass() {
        return this.fakeMethod.getRealClass();
    }

    private void makeReentrant() {
        this.proceedingInvocation = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean update() {
        FakeInvocation invocation;
        if (this.proceedingInvocation != null && (invocation = this.proceedingInvocation.get()) != null && invocation.proceeding) {
            invocation.proceeding = false;
            return false;
        }
        Object object = this.invocationCountLock;
        synchronized (object) {
            ++this.invocationCount;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTimesInvoked() {
        Object object = this.invocationCountLock;
        synchronized (object) {
            return this.invocationCount;
        }
    }

    @Nonnull
    Member getRealMethodOrConstructor(@Nonnull String fakedClassDesc, @Nonnull String fakedMethodName, @Nonnull String fakedMethodDesc) {
        Class fakedClass = ClassLoad.loadFromLoader(THIS_CL, fakedClassDesc.replace('/', '.'));
        return this.getRealMethodOrConstructor(fakedClass, fakedMethodName, fakedMethodDesc);
    }

    @Nonnull
    Member getRealMethodOrConstructor(@Nonnull Class<?> fakedClass, @Nonnull String fakedMethodName, @Nonnull String fakedMethodDesc) {
        Member member = this.realMethodOrConstructor;
        if (member == null || !fakedClass.equals(this.realClass)) {
            RealMethodOrConstructor realMember;
            String memberName = "$init".equals(fakedMethodName) ? "<init>" : fakedMethodName;
            try {
                realMember = new RealMethodOrConstructor(fakedClass, memberName, fakedMethodDesc);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            member = realMember.getMember();
            if (!this.fakeMethod.isAdvice) {
                this.realMethodOrConstructor = member;
                this.realClass = fakedClass;
            }
        }
        return member;
    }

    boolean shouldProceedIntoRealImplementation(@Nullable Object fake, @Nonnull String classDesc) {
        FakeInvocation pendingInvocation;
        return this.proceedingInvocation != null && (pendingInvocation = this.proceedingInvocation.get()) != null && pendingInvocation.isMethodInSuperclass(fake, classDesc);
    }

    void prepareToProceed(@Nonnull FakeInvocation invocation) {
        if (this.proceedingInvocation == null) {
            throw new UnsupportedOperationException("Cannot proceed into abstract/interface method");
        }
        if (this.fakeMethod.isForNativeMethod()) {
            throw new UnsupportedOperationException("Cannot proceed into real implementation of native method");
        }
        FakeInvocation previousInvocation = this.proceedingInvocation.get();
        if (previousInvocation != null) {
            invocation.setPrevious(previousInvocation);
        }
        this.proceedingInvocation.set(invocation);
    }

    void prepareToProceedFromNonRecursiveFake(@Nonnull FakeInvocation invocation) {
        assert (this.proceedingInvocation != null);
        this.proceedingInvocation.set(invocation);
    }

    void clearProceedIndicator() {
        assert (this.proceedingInvocation != null);
        FakeInvocation currentInvocation = this.proceedingInvocation.get();
        FakeInvocation previousInvocation = (FakeInvocation)currentInvocation.getPrevious();
        this.proceedingInvocation.set(previousInvocation);
    }

    @Nonnull
    Method getFakeMethod(@Nonnull Class<?> fakeClass, @Nonnull Class<?>[] parameterTypes) {
        if (this.actualFakeMethod == null) {
            this.actualFakeMethod = MethodReflection.findCompatibleMethod(fakeClass, this.fakeMethod.name, parameterTypes);
        }
        return this.actualFakeMethod;
    }
}

