/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.reflection.MethodReflection;
import mockit.internal.util.Utilities;

final class InterfaceResolution {
    @Nonnull
    private final NavigableMap<ParameterizedType, Method> interfaceResolutionMethods = new TreeMap<ParameterizedType, Method>(new Comparator<ParameterizedType>(){

        @Override
        public int compare(ParameterizedType t1, ParameterizedType t2) {
            Type targetType2;
            if (t1 == t2) {
                return 0;
            }
            Type targetType1 = t1.getActualTypeArguments()[0];
            if (targetType1 == (targetType2 = t2.getActualTypeArguments()[0])) {
                return 0;
            }
            if (targetType1 instanceof WildcardType) {
                if (targetType2 instanceof WildcardType) {
                    return InterfaceResolution.compareTypesFromResolutionMethods((WildcardType)targetType1, (WildcardType)targetType2);
                }
                return 1;
            }
            return -1;
        }
    });

    InterfaceResolution() {
    }

    private static int compareTypesFromResolutionMethods(@Nonnull WildcardType type1, @Nonnull WildcardType type2) {
        Type upperBound2;
        Class<?> classOfUpperBound2;
        Type upperBound1 = type1.getUpperBounds()[0];
        Class<?> classOfUpperBound1 = Utilities.getClassType(upperBound1);
        if (classOfUpperBound1.isAssignableFrom(classOfUpperBound2 = Utilities.getClassType(upperBound2 = type2.getUpperBounds()[0]))) {
            return 1;
        }
        if (classOfUpperBound2.isAssignableFrom(classOfUpperBound1)) {
            return -1;
        }
        return classOfUpperBound1.getName().compareTo(classOfUpperBound2.getName());
    }

    boolean canResolveInterfaces() {
        return !this.interfaceResolutionMethods.isEmpty();
    }

    void addInterfaceResolutionMethod(@Nonnull ParameterizedType interfaceType, @Nonnull Method resolutionMethod) {
        this.interfaceResolutionMethods.put(interfaceType, resolutionMethod);
    }

    @Nullable
    Class<?> resolveInterface(@Nonnull Class<?> anInterface, @Nonnull Object testClassInstance) {
        if (this.interfaceResolutionMethods.isEmpty()) {
            return null;
        }
        for (Map.Entry typeAndMethod : this.interfaceResolutionMethods.entrySet()) {
            Class implementationClass;
            ParameterizedType acceptedType = (ParameterizedType)typeAndMethod.getKey();
            Method method = (Method)typeAndMethod.getValue();
            Type targetType = acceptedType.getActualTypeArguments()[0];
            if (targetType != anInterface && (!(targetType instanceof WildcardType) || !InterfaceResolution.satisfiesUpperBounds(anInterface, (WildcardType)targetType)) || (implementationClass = (Class)MethodReflection.invoke(testClassInstance, method, anInterface)) == null) continue;
            return implementationClass;
        }
        return null;
    }

    private static boolean satisfiesUpperBounds(@Nonnull Class<?> interfaceType, @Nonnull WildcardType targetType) {
        for (Type upperBound : targetType.getUpperBounds()) {
            Class<?> classOfUpperBound = Utilities.getClassType(upperBound);
            if (classOfUpperBound.isAssignableFrom(interfaceType)) continue;
            return false;
        }
        return true;
    }
}

