/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection.constructor;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.types.JavaType;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.injection.InjectionProviders;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.Injector;
import mockit.internal.injection.TestedClass;
import mockit.internal.injection.constructor.ConstructorParameter;
import mockit.internal.injection.full.FullInjection;
import mockit.internal.reflection.ConstructorReflection;
import mockit.internal.state.ParameterNames;
import mockit.internal.state.TestRun;
import mockit.internal.util.MethodFormatter;
import mockit.internal.util.StackTrace;
import mockit.internal.util.Utilities;

public final class ConstructorInjection
extends Injector {
    @Nonnull
    private final Constructor<?> constructor;

    public ConstructorInjection(@Nonnull InjectionState injectionState, @Nullable FullInjection fullInjection, @Nonnull Constructor<?> constructor) {
        super(injectionState, fullInjection);
        Utilities.ensureThatMemberIsAccessible(constructor);
        this.constructor = constructor;
    }

    @Nullable
    public Object instantiate(@Nonnull List<InjectionProvider> parameterProviders, @Nonnull TestedClass testedClass, boolean required, boolean needToConstruct) {
        Type[] parameterTypes = this.constructor.getGenericParameterTypes();
        int n = parameterTypes.length;
        List<InjectionProvider> consumedInjectables = n == 0 ? null : this.injectionState.injectionProviders.saveConsumedInjectionProviders();
        Object[] arguments = n == 0 ? Utilities.NO_ARGS : new Object[n];
        boolean varArgs = this.constructor.isVarArgs();
        if (varArgs) {
            --n;
        }
        for (int i = 0; i < n; ++i) {
            Object value;
            InjectionProvider parameterProvider = parameterProviders.get(i);
            if (parameterProvider instanceof ConstructorParameter) {
                value = this.createOrReuseArgumentValue((ConstructorParameter)parameterProvider, required);
                if (value == null && !needToConstruct) {
                    return null;
                }
            } else {
                value = this.getArgumentValueToInject(parameterProvider, i);
            }
            if (value == InjectionProvider.NULL) continue;
            Type parameterType = parameterTypes[i];
            arguments[i] = InjectionPoint.wrapInProviderIfNeeded(parameterType, value);
        }
        if (varArgs) {
            Type parameterType = parameterTypes[n];
            arguments[n] = this.obtainInjectedVarargsArray(parameterType, testedClass);
        }
        if (consumedInjectables != null) {
            this.injectionState.injectionProviders.restoreConsumedInjectionProviders(consumedInjectables);
        }
        return this.invokeConstructor(arguments);
    }

    @Nullable
    private Object createOrReuseArgumentValue(@Nonnull ConstructorParameter constructorParameter, boolean required) {
        Object givenValue = constructorParameter.getValue(null);
        if (givenValue != null) {
            return givenValue;
        }
        assert (this.fullInjection != null);
        Class<?> parameterClass = constructorParameter.getClassOfDeclaredType();
        Object newOrReusedValue = null;
        if (FullInjection.isInstantiableType(parameterClass)) {
            Type parameterType = constructorParameter.getDeclaredType();
            InjectionPoint.KindOfInjectionPoint kindOfInjectionPoint = InjectionPoint.kindOfInjectionPoint(this.constructor);
            this.injectionState.injectionProviders.setTypeOfInjectionPoint(parameterType, kindOfInjectionPoint);
            String qualifiedName = InjectionPoint.getQualifiedName(constructorParameter.getAnnotations());
            TestedClass nextTestedClass = new TestedClass(parameterType, parameterClass);
            newOrReusedValue = this.fullInjection.createOrReuseInstance(nextTestedClass, this, constructorParameter, qualifiedName);
        } else {
            this.fullInjection.setInjectionProvider(constructorParameter);
        }
        if (newOrReusedValue == null && required) {
            String parameterName = constructorParameter.getName();
            String message = "Missing @Tested or @Injectable" + this.missingValueDescription(parameterName) + "\r\n  when initializing " + this.fullInjection;
            IllegalStateException injectionFailure = new IllegalStateException(message);
            StackTrace.filterStackTrace(injectionFailure);
            throw injectionFailure;
        }
        return newOrReusedValue;
    }

    @Nonnull
    private Object getArgumentValueToInject(@Nonnull InjectionProvider injectable, int parameterIndex) {
        Object argument = this.injectionState.getValueToInject(injectable);
        if (argument == null) {
            String constructorDesc;
            String classDesc = this.getClassDesc();
            String parameterName = ParameterNames.getName(classDesc, constructorDesc = this.getConstructorDesc(), parameterIndex);
            if (parameterName == null) {
                parameterName = injectable.getName();
            }
            throw new IllegalArgumentException("No injectable value available" + this.missingValueDescription(parameterName));
        }
        return argument;
    }

    @Nonnull
    private String getClassDesc() {
        return JavaType.getInternalName(this.constructor.getDeclaringClass());
    }

    @Nonnull
    private String getConstructorDesc() {
        return "<init>" + JavaType.getConstructorDescriptor(this.constructor);
    }

    @Nonnull
    private Object obtainInjectedVarargsArray(@Nonnull Type parameterType, @Nonnull TestedClass testedClass) {
        InjectionProvider injectable;
        Type varargsElementType = InjectionPoint.getTypeOfInjectionPointFromVarargsParameter(parameterType);
        InjectionPoint.KindOfInjectionPoint kindOfInjectionPoint = InjectionPoint.kindOfInjectionPoint(this.constructor);
        InjectionProviders injectionProviders = this.injectionState.injectionProviders;
        injectionProviders.setTypeOfInjectionPoint(varargsElementType, kindOfInjectionPoint);
        ArrayList<Object> varargValues = new ArrayList<Object>();
        while ((injectable = injectionProviders.findNextInjectableForInjectionPoint(testedClass)) != null) {
            Object value = this.injectionState.getValueToInject(injectable);
            if (value == null) continue;
            value = InjectionPoint.wrapInProviderIfNeeded(varargsElementType, value);
            varargValues.add(value);
        }
        Object varargArray = ConstructorInjection.newArrayFromList(varargsElementType, varargValues);
        return varargArray;
    }

    @Nonnull
    private static Object newArrayFromList(@Nonnull Type elementType, @Nonnull List<Object> values) {
        Class<?> componentType = Utilities.getClassType(elementType);
        int elementCount = values.size();
        Object array = Array.newInstance(componentType, elementCount);
        for (int i = 0; i < elementCount; ++i) {
            Array.set(array, i, values.get(i));
        }
        return array;
    }

    @Nonnull
    private String missingValueDescription(@Nonnull String name) {
        String classDesc = this.getClassDesc();
        String constructorDesc = this.getConstructorDesc();
        String constructorDescription = new MethodFormatter(classDesc, constructorDesc).toString();
        int p = constructorDescription.indexOf(35);
        String friendlyConstructorDesc = constructorDescription.substring(p + 1).replace("java.lang.", "");
        return " for parameter \"" + name + "\" in constructor " + friendlyConstructorDesc;
    }

    @Nonnull
    private Object invokeConstructor(@Nonnull Object[] arguments) {
        TestRun.exitNoMockingZone();
        try {
            Object obj = ConstructorReflection.invokeAccessible(this.constructor, arguments);
            return obj;
        }
        finally {
            TestRun.enterNoMockingZone();
        }
    }
}

