/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection.constructor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.types.JavaType;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.injection.InjectionProviders;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.TestedClass;
import mockit.internal.injection.constructor.ConstructorParameter;
import mockit.internal.state.ParameterNames;
import mockit.internal.util.ParameterNameExtractor;

public final class ConstructorSearch {
    private static final int CONSTRUCTOR_ACCESS = 7;
    @Nonnull
    private final InjectionState injectionState;
    @Nonnull
    private final TestedClass testedClass;
    @Nonnull
    private final String testedClassDesc;
    @Nonnull
    public List<InjectionProvider> parameterProviders;
    private final boolean withFullInjection;
    @Nullable
    private Constructor<?> constructor;
    @Nullable
    private StringBuilder searchResults;
    private static final Comparator<Constructor<?>> CONSTRUCTOR_COMPARATOR = new Comparator<Constructor<?>>(){

        @Override
        public int compare(Constructor<?> c1, Constructor<?> c2) {
            return ConstructorSearch.compareAccessibility(c1, c2);
        }
    };

    public ConstructorSearch(@Nonnull InjectionState injectionState, @Nonnull TestedClass testedClass, boolean withFullInjection) {
        this.injectionState = injectionState;
        this.testedClass = testedClass;
        Class<?> declaredClass = testedClass.getDeclaredClass();
        this.testedClassDesc = ParameterNameExtractor.extractNames(declaredClass);
        this.parameterProviders = new ArrayList<InjectionProvider>();
        this.withFullInjection = withFullInjection;
    }

    @Nullable
    public Constructor<?> findConstructorToUse() {
        this.constructor = null;
        Class<?> declaredClass = this.testedClass.targetClass;
        Constructor<?>[] constructors = declaredClass.getDeclaredConstructors();
        if (!this.findSingleAnnotatedConstructor(constructors)) {
            this.findSatisfiedConstructorWithMostParameters(constructors);
        }
        return this.constructor;
    }

    private boolean findSingleAnnotatedConstructor(@Nonnull Constructor<?>[] constructors) {
        for (Constructor<?> c : constructors) {
            if (InjectionPoint.kindOfInjectionPoint(c) == InjectionPoint.KindOfInjectionPoint.NotAnnotated) continue;
            List<InjectionProvider> providersFound = this.findParameterProvidersForConstructor(c);
            if (providersFound != null) {
                this.parameterProviders = providersFound;
                this.constructor = c;
            }
            return true;
        }
        return false;
    }

    private void findSatisfiedConstructorWithMostParameters(@Nonnull Constructor<?>[] constructors) {
        ConstructorSearch.sortConstructorsWithMostAccessibleFirst(constructors);
        Constructor<?> unresolvedConstructor = null;
        List<InjectionProvider> incompleteProviders = null;
        for (Constructor<?> candidateConstructor : constructors) {
            List<InjectionProvider> providersFound = this.findParameterProvidersForConstructor(candidateConstructor);
            if (providersFound == null) continue;
            if (this.withFullInjection && ConstructorSearch.containsUnresolvedProvider(providersFound)) {
                if (unresolvedConstructor != null && !ConstructorSearch.isLargerConstructor(candidateConstructor, providersFound, unresolvedConstructor, incompleteProviders)) continue;
                unresolvedConstructor = candidateConstructor;
                incompleteProviders = providersFound;
                continue;
            }
            if (this.constructor != null && !ConstructorSearch.isLargerConstructor(candidateConstructor, providersFound, this.constructor, this.parameterProviders)) continue;
            this.constructor = candidateConstructor;
            this.parameterProviders = providersFound;
        }
        this.selectConstructorWithUnresolvedParameterIfMoreAccessible(unresolvedConstructor, incompleteProviders);
    }

    private static void sortConstructorsWithMostAccessibleFirst(@Nonnull Constructor<?>[] constructors) {
        if (constructors.length > 1) {
            Arrays.sort(constructors, CONSTRUCTOR_COMPARATOR);
        }
    }

    private static int compareAccessibility(@Nonnull Constructor<?> c1, @Nonnull Constructor<?> c2) {
        int m2;
        int m1 = ConstructorSearch.getModifiers(c1);
        if (m1 == (m2 = ConstructorSearch.getModifiers(c2))) {
            return 0;
        }
        if (m1 == 1) {
            return -1;
        }
        if (m2 == 1) {
            return 1;
        }
        if (m1 == 4) {
            return -1;
        }
        if (m2 == 4) {
            return 1;
        }
        if (m2 == 2) {
            return -1;
        }
        return 1;
    }

    private static boolean containsUnresolvedProvider(@Nonnull List<InjectionProvider> providersFound) {
        for (InjectionProvider provider : providersFound) {
            if (!(provider instanceof ConstructorParameter) || provider.getValue(null) != null) continue;
            return true;
        }
        return false;
    }

    private static boolean isLargerConstructor(@Nonnull Constructor<?> candidateConstructor, @Nonnull List<InjectionProvider> providersFound, @Nonnull Constructor<?> previousSatisfiableConstructor, @Nonnull List<InjectionProvider> previousProviders) {
        return ConstructorSearch.getModifiers(candidateConstructor) == ConstructorSearch.getModifiers(previousSatisfiableConstructor) && providersFound.size() >= previousProviders.size();
    }

    private static int getModifiers(@Nonnull Constructor<?> c) {
        return 7 & c.getModifiers();
    }

    @Nullable
    private List<InjectionProvider> findParameterProvidersForConstructor(@Nonnull Constructor<?> candidate) {
        Type parameterType;
        InjectionProvider injectable;
        Type[] parameterTypes = candidate.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = candidate.getParameterAnnotations();
        int n = parameterTypes.length;
        ArrayList<InjectionProvider> providersFound = new ArrayList<InjectionProvider>(n);
        boolean varArgs = candidate.isVarArgs();
        if (varArgs) {
            --n;
        }
        this.printCandidateConstructorNameIfRequested(candidate);
        String constructorDesc = "<init>" + JavaType.getConstructorDescriptor(candidate);
        InjectionProviders injectionProviders = this.injectionState.injectionProviders;
        InjectionPoint.KindOfInjectionPoint kindOfInjectionPoint = InjectionPoint.kindOfInjectionPoint(candidate);
        for (int i = 0; i < n; ++i) {
            Type parameterType2 = parameterTypes[i];
            injectionProviders.setTypeOfInjectionPoint(parameterType2, kindOfInjectionPoint);
            String parameterName = ParameterNames.getName(this.testedClassDesc, constructorDesc, i);
            Annotation[] appliedAnnotations = parameterAnnotations[i];
            InjectionProvider provider = this.findOrCreateInjectionProvider(parameterType2, parameterName, appliedAnnotations);
            if (provider == null || providersFound.contains(provider)) {
                this.printParameterOfCandidateConstructorIfRequested(parameterName, provider);
                return null;
            }
            providersFound.add(provider);
        }
        if (varArgs && (injectable = this.hasInjectedValuesForVarargsParameter(parameterType = parameterTypes[n], kindOfInjectionPoint, injectionProviders)) != null) {
            providersFound.add(injectable);
        }
        return providersFound;
    }

    @Nullable
    private InjectionProvider findOrCreateInjectionProvider(@Nonnull Type parameterType, @Nullable String parameterName, @Nonnull Annotation[] parameterAnnotations) {
        String qualifiedName = InjectionPoint.getQualifiedName(parameterAnnotations);
        if (parameterName == null && qualifiedName == null) {
            return null;
        }
        boolean qualified = qualifiedName != null;
        String targetName = qualified ? qualifiedName : parameterName;
        InjectionProvider provider = this.injectionState.injectionProviders.getProviderByTypeAndOptionallyName(targetName, this.testedClass);
        if (provider != null) {
            return provider;
        }
        InjectionPoint injectionPoint = new InjectionPoint(parameterType, targetName, qualifiedName);
        Object valueForParameter = this.injectionState.getTestedValue(this.testedClass, injectionPoint);
        if (valueForParameter == null && !this.withFullInjection) {
            return null;
        }
        return new ConstructorParameter(parameterType, parameterAnnotations, targetName, valueForParameter);
    }

    @Nullable
    private InjectionProvider hasInjectedValuesForVarargsParameter(@Nonnull Type parameterType, @Nonnull InjectionPoint.KindOfInjectionPoint kindOfInjectionPoint, @Nonnull InjectionProviders injectionProviders) {
        Type varargsElementType = InjectionPoint.getTypeOfInjectionPointFromVarargsParameter(parameterType);
        injectionProviders.setTypeOfInjectionPoint(varargsElementType, kindOfInjectionPoint);
        return injectionProviders.findNextInjectableForInjectionPoint(this.testedClass);
    }

    private void selectConstructorWithUnresolvedParameterIfMoreAccessible(@Nullable Constructor<?> unresolvedConstructor, List<InjectionProvider> incompleteProviders) {
        if (unresolvedConstructor != null && (this.constructor == null || ConstructorSearch.compareAccessibility(unresolvedConstructor, this.constructor) < 0)) {
            this.constructor = unresolvedConstructor;
            this.parameterProviders = incompleteProviders;
        }
    }

    @Nonnull
    public String getDescription() {
        this.searchResults = new StringBuilder();
        this.findConstructorToUse();
        String contents = this.searchResults.toString();
        this.searchResults = null;
        return contents;
    }

    private void printCandidateConstructorNameIfRequested(@Nonnull Constructor<?> candidate) {
        if (this.searchResults != null) {
            String constructorDesc = candidate.toGenericString().replace("java.lang.", "").replace(",", ", ");
            this.searchResults.append("\r\n  ").append(constructorDesc).append("\r\n");
        }
    }

    private void printParameterOfCandidateConstructorIfRequested(@Nullable String parameterName, @Nullable InjectionProvider injectableFound) {
        if (this.searchResults != null) {
            this.searchResults.append("    disregarded because ");
            if (parameterName == null) {
                this.searchResults.append("parameter names are not available");
            } else {
                this.searchResults.append("no tested/injectable value was found for parameter \"").append(parameterName).append('\"');
                if (injectableFound != null) {
                    this.searchResults.append(" that hadn't been used already");
                }
            }
        }
    }
}

