/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.common.util;

import fi.kanta.common.exception.PropertyException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class PropertyReader {
    private static final String ENCODING_UTF8 = "UTF-8";
    private static ConcurrentHashMap<String, Properties> cache;

    public static Properties getProperties(String propertiesFileName) throws PropertyException {
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        Properties properties = null;
        if (cache != null && cache.containsKey(propertiesFileName)) {
            properties = cache.get(propertiesFileName);
        } else {
            properties = new Properties();
            try {
                inputStream = PropertyReader.class.getClassLoader().getResourceAsStream(propertiesFileName);
                inputStreamReader = new InputStreamReader(inputStream, ENCODING_UTF8);
                properties.load(inputStreamReader);
                if (cache == null) {
                    cache = new ConcurrentHashMap();
                }
                cache.put(propertiesFileName, properties);
            }
            catch (FileNotFoundException e) {
                throw new PropertyException("Cannot read properties file.", propertiesFileName, null, e);
            }
            catch (IOException e) {
                throw new PropertyException("Cannot access properties file.", propertiesFileName, null, e);
            }
            finally {
                try {
                    inputStream.close();
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    throw new PropertyException("Cannot close InputStream or InputStreamReader", null, null, e);
                }
            }
        }
        return properties;
    }

    public static String getProperty(String propertiesFileName, String propertyKey) throws PropertyException {
        Properties props = PropertyReader.getProperties(propertiesFileName);
        String property = props.getProperty(propertyKey);
        return property;
    }

    public static void clearCache() {
        cache.clear();
    }

    public static Properties clearProperties(String propertiesFileName) {
        return cache.remove(propertiesFileName);
    }

    public static String removeProperty(String propertiesFileName, String property) {
        return (String)cache.get(propertiesFileName).remove(property);
    }
}

