/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.cos.GFCosTextString;
import org.verapdf.gf.model.impl.pd.GFPDDestination;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.actions.GFPDAction;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosTextString;
import org.verapdf.model.pdlayer.PDAction;
import org.verapdf.model.pdlayer.PDOutline;
import org.verapdf.pd.PDDestination;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.PDOutlineItem;

public class GFPDOutline
extends GFPDObject
implements PDOutline {
    public static final String OUTLINE_TYPE = "PDOutline";
    public static final String TITLE = "Title";
    public static final String ACTION = "A";
    public static final String DEST = "Dest";
    private final String id;

    public GFPDOutline(PDOutlineItem simplePDObject, String id) {
        super((PDObject)simplePDObject, OUTLINE_TYPE);
        this.id = id;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "A": {
                return this.getAction();
            }
            case "Dest": {
                return this.getDestination();
            }
            case "Title": {
                return this.getTitle();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDAction> getAction() {
        org.verapdf.pd.actions.PDAction action = ((PDOutlineItem)this.simplePDObject).getAction();
        if (action != null) {
            ArrayList<PDAction> actions = new ArrayList<PDAction>(1);
            PDAction pdAction = GFPDAction.getAction(action);
            actions.add(pdAction);
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDDestination> getDestination() {
        COSObject destination = ((PDOutlineItem)this.simplePDObject).getDestination();
        if (!destination.empty() && !this.simplePDObject.knownKey(ASAtom.A)) {
            ArrayList<GFPDDestination> destinations = new ArrayList<GFPDDestination>(1);
            destinations.add(new GFPDDestination(new PDDestination(destination)));
            return Collections.unmodifiableList(destinations);
        }
        return Collections.emptyList();
    }

    private List<CosTextString> getTitle() {
        COSObject title = this.simplePDObject.getKey(ASAtom.TITLE);
        if (title != null && title.getType() == COSObjType.COS_STRING) {
            ArrayList<GFCosTextString> list = new ArrayList<GFCosTextString>(1);
            list.add(new GFCosTextString((COSString)title.getDirectBase()));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

