/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.cos;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.cos.GFCosDict;
import org.verapdf.gf.model.impl.pd.util.XMPChecker;
import org.verapdf.metadata.fixer.gf.utils.DateConverter;
import org.verapdf.model.coslayer.CosInfo;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TypeConverter;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.impl.VeraPDFMeta;

public class GFCosInfo
extends GFCosDict
implements CosInfo {
    public static final String INFORMATION_TYPE = "CosInfo";
    private final VeraPDFMeta meta = this.parseMetadata();

    public GFCosInfo(COSDictionary dictionary) {
        super(dictionary, INFORMATION_TYPE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VeraPDFMeta parseMetadata() {
        COSDocument document = StaticResources.getDocument().getDocument();
        try (InputStream metadataStream = XMPChecker.getMetadataStream(document);){
            if (metadataStream == null) return null;
            VeraPDFMeta veraPDFMeta = VeraPDFMeta.parse((InputStream)metadataStream);
            return veraPDFMeta;
        }
        catch (IOException | XMPException throwable) {
            // empty catch block
        }
        return null;
    }

    public String getModDate() {
        return this.baseObject.getStringKey(ASAtom.MOD_DATE);
    }

    public String getCreationDate() {
        return this.baseObject.getStringKey(ASAtom.CREATION_DATE);
    }

    private String getStringProperty(ASAtom name) {
        COSObject value = this.baseObject.getKey(name);
        if (value != null && !value.empty() && value.getType() != COSObjType.COS_NULL) {
            if (value.getType() == COSObjType.COS_STRING) {
                return XMPChecker.getStringWithoutTrailingZero(value.getString());
            }
            return value.toString();
        }
        return null;
    }

    public String getTitle() {
        return this.getStringProperty(ASAtom.TITLE);
    }

    public String getAuthor() {
        return this.getStringProperty(ASAtom.AUTHOR);
    }

    public String getSubject() {
        return this.getStringProperty(ASAtom.SUBJECT);
    }

    public String getProducer() {
        return this.getStringProperty(ASAtom.PRODUCER);
    }

    public String getCreator() {
        return this.getStringProperty(ASAtom.CREATOR);
    }

    public String getKeywords() {
        return this.getStringProperty(ASAtom.KEYWORDS);
    }

    public String getXMPTitle() {
        if (this.meta != null) {
            try {
                return this.meta.getTitle();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getXMPCreator() {
        if (this.meta != null) {
            try {
                List creator = this.meta.getCreator();
                if (creator != null) {
                    if (creator.size() == 1) {
                        return (String)creator.get(0);
                    }
                    return '[' + String.join((CharSequence)",", creator) + ']';
                }
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public Long getXMPCreatorSize() {
        if (this.meta != null) {
            try {
                List creator = this.meta.getCreator();
                if (creator != null) {
                    return creator.size();
                }
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getXMPProducer() {
        if (this.meta != null) {
            try {
                return this.meta.getProducer();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getXMPCreatorTool() {
        if (this.meta != null) {
            try {
                return this.meta.getCreatorTool();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getXMPKeywords() {
        if (this.meta != null) {
            try {
                return this.meta.getKeywords();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getXMPDescription() {
        if (this.meta != null) {
            try {
                return this.meta.getDescription();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public Boolean getdoCreationDatesMatch() {
        Calendar xmpCreateDate = null;
        if (this.meta != null) {
            try {
                xmpCreateDate = this.meta.getCreateDate();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        String creationDate = this.getCreationDate();
        if (xmpCreateDate != null && creationDate != null) {
            Calendar creationDateCalendar = TypeConverter.parseDate((String)creationDate);
            return creationDateCalendar != null && xmpCreateDate.compareTo(creationDateCalendar) == 0;
        }
        return null;
    }

    public Boolean getdoModDatesMatch() {
        Calendar xmpModifyDate = null;
        if (this.meta != null) {
            try {
                xmpModifyDate = this.meta.getModifyDate();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        String modDate = this.getModDate();
        if (xmpModifyDate != null && modDate != null) {
            Calendar modDateCalendar = TypeConverter.parseDate((String)modDate);
            return modDateCalendar != null && xmpModifyDate.compareTo(modDateCalendar) == 0;
        }
        return null;
    }

    public String getXMPCreateDate() {
        if (this.meta != null) {
            try {
                return DateConverter.toXMPDateFormat((Calendar)this.meta.getCreateDate());
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getXMPModifyDate() {
        if (this.meta != null) {
            try {
                return DateConverter.toXMPDateFormat((Calendar)this.meta.getModifyDate());
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return null;
    }
}

