/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.visitor;

import java.util.Map;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSIndirect;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSNull;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSString;
import org.verapdf.cos.visitor.IVisitor;

public class COSCopier
implements IVisitor {
    private final COSObject copy;

    public COSCopier(COSObject copy) {
        this.copy = copy;
    }

    @Override
    public void visitFromBoolean(COSBoolean obj) {
        this.copy.assign(COSBoolean.construct(obj.get()));
    }

    @Override
    public void visitFromInteger(COSInteger obj) {
        this.copy.assign(COSInteger.construct(obj.get()));
    }

    @Override
    public void visitFromReal(COSReal obj) {
        this.copy.assign(COSReal.construct(obj.get()));
    }

    @Override
    public void visitFromString(COSString obj) {
        this.copy.assign(COSString.construct(obj.get(), obj.isHexadecimal()));
    }

    @Override
    public void visitFromName(COSName obj) {
        this.copy.assign(COSName.construct(obj.get()));
    }

    @Override
    public void visitFromArray(COSArray obj) {
        this.copy.assign(COSArray.construct());
        for (int i = 0; i < obj.size(); ++i) {
            COSObject element = new COSObject();
            COSCopier copier = new COSCopier(element);
            obj.at(i).accept(copier);
            this.copy.add(element);
        }
    }

    @Override
    public void visitFromDictionary(COSDictionary obj) {
        this.copy.assign(COSDictionary.construct());
        for (Map.Entry<ASAtom, COSObject> entry : obj.getEntrySet()) {
            COSObject element = new COSObject();
            COSCopier copier = new COSCopier(element);
            entry.getValue().accept(copier);
            this.copy.setKey(entry.getKey(), element);
        }
    }

    @Override
    public void visitFromStream(COSStream obj) {
        this.visitFromDictionary(obj);
        this.copy.assign(COSStream.construct((COSDictionary)this.copy.get(), obj.getData(), obj.getFilterFlags()));
    }

    @Override
    public void visitFromNull(COSNull obj) {
        this.copy.assign(COSNull.construct());
    }

    @Override
    public void visitFromIndirect(COSIndirect obj) {
        try {
            this.copy.set(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

