/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.external;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceCMYK;
import org.verapdf.pd.colors.PDICCBased;
import org.verapdf.pd.colors.PDLab;

public class JPEG2000 {
    private static final Logger LOGGER = Logger.getLogger(JPEG2000.class.getCanonicalName());
    private static final Long DEFAULT_NR_COLOR_CHANNELS = 0L;
    private static final Long DEFAULT_NR_COLOR_SPACE_SPECS = 0L;
    private static final Long DEFAULT_NR_COLOR_SPACES_WITH_APPROX_FIELD = 0L;
    private static final Long DEFAULT_COLR_METHOD = 0L;
    private static final Long DEFAULT_COLR_ENUM_CS = null;
    private static final Long DEFAULT_BIT_DEPTH = 0L;
    private static final Boolean DEFAULT_BPCC_BOX_PRESENT = Boolean.FALSE;
    private static final PDColorSpace DEFAULT_COLOR_SPACE = null;
    private static final double[] ILLUMINANT_D50 = new double[]{0.9642, 1.0, 0.8251};
    private static final byte[] sign = new byte[]{0, 0, 0, 12, 106, 80, 32, 32, 13, 10, -121, 10};
    private static final byte[] header = new byte[]{106, 112, 50, 104};
    private static final byte[] ihdr = new byte[]{105, 104, 100, 114};
    private static final byte[] bpcc = new byte[]{98, 112, 99, 99};
    private static final byte[] colr = new byte[]{99, 111, 108, 114};
    private final Long nrColorChannels;
    private final Long nrColorSpaceSpecs;
    private final Long nrColorSpacesWithApproxField;
    private final Long colrMethod;
    private final Long colrEnumCS;
    private final Long bitDepth;
    private final Boolean bpccBoxPresent;
    private final PDColorSpace colorSpace;

    private JPEG2000(Long nrColorChannels, Long nrColorSpaceSpecs, Long nrColorSpacesWithApproxField, Long colrMethod, Long colrEnumCS, Long bitDepth, Boolean bpccBoxPresent, PDColorSpace colorSpace) {
        this.nrColorChannels = nrColorChannels;
        this.nrColorSpaceSpecs = nrColorSpaceSpecs;
        this.nrColorSpacesWithApproxField = nrColorSpacesWithApproxField;
        this.colrMethod = colrMethod;
        this.colrEnumCS = colrEnumCS;
        this.bitDepth = bitDepth;
        this.bpccBoxPresent = bpccBoxPresent;
        this.colorSpace = colorSpace;
    }

    public static JPEG2000 fromStream(ASInputStream stream) {
        Builder builder = new Builder();
        byte[] tempSign = new byte[12];
        try {
            if (stream.read(tempSign, tempSign.length) != 12 || !JPEG2000.isValidSignature(tempSign)) {
                LOGGER.log(Level.FINE, "File contains wrong signature");
                return builder.build();
            }
            long headerLeft = JPEG2000.findHeader(stream);
            if (headerLeft >= 0L) {
                JPEG2000.parseHeader(stream, headerLeft, builder);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "IO Exception reading JP2K stream", e);
        }
        return builder.build();
    }

    private static void parseHeader(ASInputStream stream, long headerLeft, Builder builder) throws IOException {
        long length;
        long leftInHeader = headerLeft;
        boolean isHeaderReachEnd = leftInHeader == 0L;
        Long nrColorSpaceSpecs = null;
        Long nrColorSpacesWithApproxField = null;
        Long firstColrMethod = null;
        Long firstColrEnumCS = null;
        Long colrMethod = null;
        Long colrEnumCS = null;
        Boolean doesFirstContainsColorSpace = null;
        PDColorSpace firstColorSpace = null;
        PDColorSpace colorSpace = null;
        do {
            byte[] lbox = new byte[4];
            byte[] tbox = new byte[4];
            if (stream.read(lbox, lbox.length) != 4 || stream.read(tbox, tbox.length) != 4) break;
            int skipped = 8;
            length = JPEG2000.convertArrayToLong(lbox);
            if (length == 1L) {
                byte[] xlbox = new byte[8];
                if (stream.read(xlbox, xlbox.length) != 8) break;
                length = JPEG2000.convertArrayToLong(xlbox);
                skipped = 16;
            }
            if (length < 0L || !isHeaderReachEnd && (length == 0L || length > leftInHeader)) break;
            long leftInBox = length - (long)skipped;
            if (JPEG2000.matches(tbox, ihdr)) {
                if (leftInBox != 14L && length != 0L) {
                    LOGGER.log(Level.FINE, "Image header content does not contain 14 bytes");
                    break;
                }
                JPEG2000.skipBytes(stream, 8L);
                byte[] nc = new byte[2];
                if (stream.read(nc, nc.length) != 2) {
                    LOGGER.log(Level.FINE, "Can not read number of components");
                    break;
                }
                long ncColorChannels = JPEG2000.convertArrayToLong(nc);
                builder.nrColorChannels(ncColorChannels);
                byte[] bpc = new byte[1];
                if (stream.read(bpc, bpc.length) != 1) {
                    LOGGER.log(Level.FINE, "Can not read bitDepth");
                    break;
                }
                long bitDepth = bpc[0] + 1;
                builder.bitDepth(bitDepth);
                JPEG2000.skipBytes(stream, 3L);
                continue;
            }
            if (JPEG2000.matches(tbox, bpcc)) {
                builder.bpccBoxPresent(Boolean.TRUE);
                JPEG2000.skipBytes(stream, leftInBox);
                continue;
            }
            if (JPEG2000.matches(tbox, colr)) {
                if (leftInBox < 3L) {
                    LOGGER.log(Level.FINE, "Founded 'colr' box with length less than 3");
                    break;
                }
                nrColorSpaceSpecs = nrColorSpaceSpecs == null ? Long.valueOf(1L) : Long.valueOf(nrColorSpaceSpecs + 1L);
                byte[] meth = new byte[1];
                if (stream.read(meth, meth.length) != 1) {
                    LOGGER.log(Level.FINE, "Can not read METH");
                    break;
                }
                long methValue = JPEG2000.convertArrayToLong(meth);
                if (firstColrMethod == null) {
                    firstColrMethod = methValue;
                }
                JPEG2000.skipBytes(stream, 1L);
                byte[] approx = new byte[1];
                if (stream.read(approx, approx.length) != 1) {
                    LOGGER.log(Level.FINE, "Can not read APPROX");
                    break;
                }
                long approxValue = JPEG2000.convertArrayToLong(approx);
                if (approxValue == 1L) {
                    nrColorSpacesWithApproxField = nrColorSpacesWithApproxField == null ? Long.valueOf(1L) : Long.valueOf(nrColorSpacesWithApproxField + 1L);
                    if (colrMethod == null) {
                        colrMethod = methValue;
                    }
                }
                long read = 3L;
                if (methValue == 1L) {
                    if (leftInBox < 7L) {
                        LOGGER.log(Level.FINE, "Founded 'colr' box with meth value 1 and length less than 7");
                        break;
                    }
                    byte[] enumCS = new byte[4];
                    if (stream.read(enumCS, enumCS.length) != 4) {
                        LOGGER.log(Level.FINE, "Can not read EnumCS");
                        break;
                    }
                    read += 4L;
                    long enumCSValue = JPEG2000.convertArrayToLong(enumCS);
                    if (firstColrEnumCS == null) {
                        firstColrEnumCS = enumCSValue;
                        firstColorSpace = JPEG2000.createColorSpaceFromEnumValue(firstColrEnumCS);
                        doesFirstContainsColorSpace = firstColorSpace != null;
                    }
                    if (approxValue == 1L && colrEnumCS == null) {
                        colrEnumCS = enumCSValue;
                        colorSpace = JPEG2000.createColorSpaceFromEnumValue(colrEnumCS);
                    }
                } else if (methValue == 2L) {
                    int profileLength = (int)(leftInBox - read);
                    byte[] profile = new byte[profileLength];
                    if (stream.read(profile, profileLength) != profileLength) {
                        LOGGER.log(Level.FINE, "Can not read Profile");
                        break;
                    }
                    read += (long)profileLength;
                    if (doesFirstContainsColorSpace == null) {
                        firstColorSpace = JPEG2000.createColorSpaceFromProfile(profile);
                        doesFirstContainsColorSpace = firstColorSpace != null;
                    }
                    if (approxValue == 1L && colorSpace == null) {
                        colorSpace = JPEG2000.createColorSpaceFromProfile(profile);
                    }
                }
                JPEG2000.skipBytes(stream, leftInBox - read);
                continue;
            }
            JPEG2000.skipBytes(stream, leftInBox);
        } while ((!isHeaderReachEnd || length != 0L) && (isHeaderReachEnd || (leftInHeader -= length) != 0L));
        if (nrColorSpaceSpecs != null) {
            builder.nrColorSpaceSpecs(nrColorSpaceSpecs);
        }
        if (nrColorSpacesWithApproxField != null) {
            builder.nrColorSpacesWithApproxField(nrColorSpacesWithApproxField);
        }
        if (nrColorSpacesWithApproxField != null) {
            if (colrMethod != null) {
                builder.colrMethod(colrMethod);
            }
            if (colrEnumCS != null) {
                builder.colrEnumCS(colrEnumCS);
            }
            if (colorSpace != null) {
                builder.colorSpace(colorSpace);
            }
        } else if (Long.valueOf(1L).equals(nrColorSpaceSpecs)) {
            if (firstColrMethod != null) {
                builder.colrMethod(firstColrMethod);
            }
            if (firstColrEnumCS != null) {
                builder.colrEnumCS(firstColrEnumCS);
            }
            if (firstColorSpace != null) {
                builder.colorSpace(firstColorSpace);
            }
        }
    }

    private static PDColorSpace createColorSpaceFromEnumValue(long enumCS) {
        if (enumCS > Integer.MAX_VALUE) {
            return null;
        }
        switch ((int)enumCS) {
            case 12: {
                return PDDeviceCMYK.INSTANCE;
            }
            case 14: {
                return new PDLab(ILLUMINANT_D50);
            }
            case 17: {
                return new PDICCBased(1);
            }
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: {
                return new PDICCBased(3);
            }
        }
        return null;
    }

    private static PDICCBased createColorSpaceFromProfile(byte[] profile) {
        int nrOfComp;
        String type;
        if (profile.length < 20) {
            return null;
        }
        switch (type = new String(profile, 16, 4, StandardCharsets.ISO_8859_1)) {
            case "GRAY": {
                nrOfComp = 1;
                break;
            }
            case "2CLR": {
                nrOfComp = 2;
                break;
            }
            case "XYZ ": 
            case "Lab ": 
            case "Luv ": 
            case "YCbr": 
            case "Yxy ": 
            case "RGB ": 
            case "HSV ": 
            case "HLS ": 
            case "CMY ": 
            case "3CLR": {
                nrOfComp = 3;
                break;
            }
            case "CMYK": 
            case "4CLR": {
                nrOfComp = 4;
                break;
            }
            case "5CLR": {
                nrOfComp = 5;
                break;
            }
            case "6CLR": {
                nrOfComp = 6;
                break;
            }
            case "7CLR": {
                nrOfComp = 7;
                break;
            }
            case "8CLR": {
                nrOfComp = 8;
                break;
            }
            case "9CLR": {
                nrOfComp = 9;
                break;
            }
            case "ACLR": {
                nrOfComp = 10;
                break;
            }
            case "BCLR": {
                nrOfComp = 11;
                break;
            }
            case "CCLR": {
                nrOfComp = 12;
                break;
            }
            case "DCLR": {
                nrOfComp = 13;
                break;
            }
            case "ECLR": {
                nrOfComp = 14;
                break;
            }
            case "FCLR": {
                nrOfComp = 15;
                break;
            }
            default: {
                LOGGER.log(Level.FINE, "Unknown color space signature in ICC Profile of image. Current signature: " + type);
                return null;
            }
        }
        return new PDICCBased(nrOfComp, profile);
    }

    private static long findHeader(ASInputStream stream) throws IOException {
        while (true) {
            byte[] lbox = new byte[4];
            byte[] tbox = new byte[4];
            if (stream.read(lbox, lbox.length) != 4 || stream.read(tbox, tbox.length) != 4) {
                return -1L;
            }
            int skipped = 8;
            long length = JPEG2000.convertArrayToLong(lbox);
            if (length == 1L) {
                byte[] xlbox = new byte[8];
                if (stream.read(xlbox, xlbox.length) != 8) {
                    return -1L;
                }
                length = JPEG2000.convertArrayToLong(xlbox);
                skipped = 16;
            }
            long left = length - (long)skipped;
            if (JPEG2000.matches(tbox, header)) {
                if (length == 0L) {
                    return 0L;
                }
                return left <= 0L ? -1L : left;
            }
            if (length == 0L || left < 0L) {
                return -1L;
            }
            JPEG2000.skipBytes(stream, left);
        }
    }

    private static void skipBytes(ASInputStream stream, long skipNumber) throws IOException {
        int needToSkip;
        int skipped;
        while (skipNumber > 0L && (skipped = stream.skip(needToSkip = (int)Math.min(skipNumber, Integer.MAX_VALUE))) != 0) {
            skipNumber -= (long)skipped;
        }
    }

    private static long convertArrayToLong(byte[] toConvert) {
        if (toConvert.length < 1 || toConvert.length > 8) {
            throw new IllegalArgumentException("Length of the converting byte array can not be greater than 8");
        }
        long res = 0L;
        for (byte aToConvert : toConvert) {
            res <<= 8;
            res += (long)(aToConvert & 0xFF);
        }
        return res;
    }

    private static boolean isValidSignature(byte[] signature) {
        return JPEG2000.matches(signature, sign);
    }

    private static boolean matches(byte[] source, byte[] match) {
        if (match.length != source.length) {
            return false;
        }
        for (int i = 0; i < match.length; ++i) {
            if (source[i] == match[i]) continue;
            return false;
        }
        return true;
    }

    public PDColorSpace getImageColorSpace() {
        return this.colorSpace;
    }

    public Long getNumberOfColorChannels() {
        return this.nrColorChannels;
    }

    public Long getNumberOfColorSpaceSpecs() {
        return this.nrColorSpaceSpecs;
    }

    public Long getNumberOfColorSpacesWithApproxField() {
        return this.nrColorSpacesWithApproxField;
    }

    public Long getColrMethod() {
        return this.colrMethod;
    }

    public Long getColrEnumCS() {
        return this.colrEnumCS;
    }

    public Long getBitDepth() {
        return this.bitDepth;
    }

    public Boolean getBPCCBoxPresent() {
        return this.bpccBoxPresent;
    }

    static /* synthetic */ Long access$000() {
        return DEFAULT_NR_COLOR_CHANNELS;
    }

    static /* synthetic */ Long access$100() {
        return DEFAULT_NR_COLOR_SPACE_SPECS;
    }

    static /* synthetic */ Long access$200() {
        return DEFAULT_NR_COLOR_SPACES_WITH_APPROX_FIELD;
    }

    static /* synthetic */ Long access$300() {
        return DEFAULT_COLR_METHOD;
    }

    static /* synthetic */ Long access$400() {
        return DEFAULT_COLR_ENUM_CS;
    }

    static /* synthetic */ Long access$500() {
        return DEFAULT_BIT_DEPTH;
    }

    static /* synthetic */ Boolean access$600() {
        return DEFAULT_BPCC_BOX_PRESENT;
    }

    static /* synthetic */ PDColorSpace access$700() {
        return DEFAULT_COLOR_SPACE;
    }

    private static class Builder {
        private Long nrColorChannels = JPEG2000.access$000();
        private Long nrColorSpaceSpecs = JPEG2000.access$100();
        private Long nrColorSpacesWithApproxField = JPEG2000.access$200();
        private Long colrMethod = JPEG2000.access$300();
        private Long colrEnumCS = JPEG2000.access$400();
        private Long bitDepth = JPEG2000.access$500();
        private Boolean bpccBoxPresent = JPEG2000.access$600();
        private PDColorSpace colorSpace = JPEG2000.access$700();

        public JPEG2000 build() {
            return new JPEG2000(this.nrColorChannels, this.nrColorSpaceSpecs, this.nrColorSpacesWithApproxField, this.colrMethod, this.colrEnumCS, this.bitDepth, this.bpccBoxPresent, this.colorSpace);
        }

        public Builder nrColorChannels(Long nrColorChannels) {
            this.nrColorChannels = nrColorChannels;
            return this;
        }

        public Builder nrColorSpaceSpecs(Long nrColorSpaceSpecs) {
            this.nrColorSpaceSpecs = nrColorSpaceSpecs;
            return this;
        }

        public Builder nrColorSpacesWithApproxField(Long nrColorSpacesWithApproxField) {
            this.nrColorSpacesWithApproxField = nrColorSpacesWithApproxField;
            return this;
        }

        public Builder colrMethod(Long colrMethod) {
            this.colrMethod = colrMethod;
            return this;
        }

        public Builder colrEnumCS(Long colrEnumCS) {
            this.colrEnumCS = colrEnumCS;
            return this;
        }

        public Builder bitDepth(Long bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public Builder bpccBoxPresent(Boolean bpccBoxPresent) {
            this.bpccBoxPresent = bpccBoxPresent;
            return this;
        }

        public Builder colorSpace(PDColorSpace colorSpace) {
            this.colorSpace = colorSpace;
            return this;
        }
    }
}

