/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSIndirect;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.exceptions.LoopedException;
import org.verapdf.exceptions.VeraPDFParserException;
import org.verapdf.pd.PDPage;
import org.verapdf.pd.PDPageTreeNode;

public class PDPageTreeBranch
extends PDPageTreeNode {
    private static final int PD_TREE_MAX_CHILD = 11;
    private int leafCount;
    private boolean isTerminal;
    private final List<PDPageTreeNode> children;

    public PDPageTreeBranch() {
        this.isTerminal = true;
        this.leafCount = 0;
        this.children = new ArrayList<PDPageTreeNode>();
        super.setObject(new COSObject());
    }

    public PDPageTreeBranch(COSObject obj) {
        this.isTerminal = true;
        this.leafCount = 0;
        this.children = new ArrayList<PDPageTreeNode>();
        super.setObject(obj);
    }

    public PDPageTreeBranch(COSObject obj, PDPageTreeBranch parentTreeBranch) {
        this.isTerminal = true;
        this.leafCount = 0;
        this.children = new ArrayList<PDPageTreeNode>();
        this.setParent(parentTreeBranch);
        super.setObject(obj);
    }

    private PDPageTreeBranch(PDPageTreeBranch leftChild, PDPageTreeBranch rightChild) {
        this.isTerminal = false;
        this.children = new ArrayList<PDPageTreeNode>();
        this.initialize();
        this.children.add(leftChild);
        this.children.add(rightChild);
        this.leafCount = leftChild.leafCount + rightChild.leafCount;
        this.updateToObject();
        leftChild.setParent(this);
        rightChild.setParent(this);
    }

    @Override
    public int getLeafCount() {
        return this.leafCount;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public PDPageTreeNode getChild(int index) {
        return this.children.get(index);
    }

    public int getIndex(PDPageTreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public PDPage findTerminalPDPage(int index) {
        if (this.isTerminal) {
            index = Math.min(index, this.leafCount);
            return (PDPage)this.getChild(index);
        }
        for (PDPageTreeNode branch : this.children) {
            if (index >= branch.getLeafCount()) {
                index -= branch.getLeafCount();
                continue;
            }
            return branch.findTerminalPDPage(index);
        }
        int lastIndex = this.children.size() - 1;
        return this.children.get(lastIndex).findTerminalPDPage(index);
    }

    @Override
    public PDPageTreeBranch findTerminal(int index) {
        if (this.isTerminal) {
            return this;
        }
        for (PDPageTreeNode branch : this.children) {
            if (index >= branch.getLeafCount()) {
                index -= branch.getLeafCount();
                continue;
            }
            return branch.findTerminal(index);
        }
        int lastIndex = this.children.size() - 1;
        return this.children.get(lastIndex).findTerminal(index);
    }

    public boolean insertLeaf(PDPage leaf, int insertAt) {
        insertAt = Math.min(insertAt, this.getChildCount());
        this.incLeafCount();
        return this.insertNode(leaf, insertAt);
    }

    @Override
    protected void updateFromObject() {
        Long leafCount;
        this.clear();
        COSObject kids = this.getObject().getKey(ASAtom.KIDS);
        if (kids != null && !kids.empty()) {
            Set<COSKey> keys = this.parentKeysForChildren();
            for (int i = 0; i < kids.size(); ++i) {
                PDPageTreeNode kid_i;
                COSObject obj = kids.at(i);
                if (keys.contains(obj.getObjectKey())) {
                    throw new LoopedException("Page tree loop found");
                }
                if (obj.getNameKey(ASAtom.TYPE) == ASAtom.PAGE) {
                    kid_i = new PDPage(obj);
                } else if (obj.getNameKey(ASAtom.TYPE) == ASAtom.PAGES) {
                    kid_i = new PDPageTreeBranch(obj, this);
                    this.isTerminal = false;
                } else {
                    throw new VeraPDFParserException("unknown type of page tree node");
                }
                kid_i.setParent(this);
                this.children.add(kid_i);
            }
        }
        if ((leafCount = this.getObject().getIntegerKey(ASAtom.COUNT)) != null) {
            this.leafCount = leafCount.intValue();
        }
    }

    private Set<COSKey> parentKeysForChildren() {
        HashSet<COSKey> res = new HashSet<COSKey>();
        for (PDPageTreeBranch curr = this; curr != null; curr = curr.getParent()) {
            COSKey objectKey = curr.getObject().getObjectKey();
            if (res.contains(objectKey)) {
                throw new LoopedException("Page tree loop found");
            }
            res.add(objectKey);
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    protected void updateToObject() {
        COSObject branch = this.getObject();
        COSObject kids = COSArray.construct();
        for (PDPageTreeNode node : this.children) {
            kids.add(node.getObject());
        }
        branch.setKey(ASAtom.KIDS, kids);
        COSObject count = COSInteger.construct(this.leafCount);
        branch.setKey(ASAtom.COUNT, count);
        PDPageTreeBranch parentNode = this.getParent();
        if (parentNode != null) {
            branch.setKey(ASAtom.PARENT, parentNode.getObject());
        }
    }

    private void initialize() {
        COSObject dict = COSDictionary.construct();
        dict.setNameKey(ASAtom.TYPE, ASAtom.PAGES);
        dict.setArrayKey(ASAtom.KIDS);
        dict.setIntegerKey(ASAtom.COUNT, 0L);
        COSObject branch = COSIndirect.construct(dict);
        this.setObject(branch);
    }

    private boolean insertNode(PDPageTreeNode node, int insertAt) {
        node.setParent(this);
        this.children.add(insertAt, node);
        this.getObject().getKey(ASAtom.KIDS).insert(insertAt, node.getObject());
        if (this.getChildCount() > 11) {
            PDPageTreeBranch rightNeighbour = new PDPageTreeBranch(this.getObject());
            if (this.getParent() != null) {
                int insPos = this.getParent().getIndex(this) + 1;
                return this.getParent().insertNode(rightNeighbour, insPos);
            }
            new PDPageTreeBranch(this, rightNeighbour);
            return true;
        }
        return false;
    }

    private void incLeafCount() {
        for (PDPageTreeBranch branch = this; branch != null; branch = branch.getParent()) {
            ++branch.leafCount;
            branch.getObject().setIntegerKey(ASAtom.COUNT, branch.leafCount);
        }
    }

    @Override
    public void clear() {
        this.children.clear();
        this.leafCount = 0;
        this.isTerminal = true;
    }
}

