/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.AnnotationFeaturesObjectAdapter;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class AnnotationFeaturesObject
extends FeaturesObject {
    private static final String SUB_TYPE = "subType";
    private static final String ANNOTATION = "annotation";
    private static final String CONTENTS = "contents";
    private static final String ANNOTATION_NAME = "annotationName";
    private static final String MODIFIED_DATE = "modifiedDate";
    private static final String INVISIBLE = "invisible";
    private static final String HIDDEN = "hidden";
    private static final String PRINT = "print";
    private static final String NO_ZOOM = "noZoom";
    private static final String NO_ROTATE = "noRotate";
    private static final String NO_VIEW = "noView";
    private static final String READ_ONLY = "readOnly";
    private static final String LOCKED = "locked";
    private static final String TOGGLE_NO_VIEW = "toggleNoView";
    private static final String LOCKED_CONTENTS = "lockedContents";

    public AnnotationFeaturesObject(AnnotationFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.ANNOTATION;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        String popupId;
        AnnotationFeaturesObjectAdapter annotationAdapter = (AnnotationFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(ANNOTATION);
        String id = annotationAdapter.getId();
        if (id != null) {
            root.setAttribute("id", id);
        }
        CreateNodeHelper.addNotEmptyNode(SUB_TYPE, annotationAdapter.getSubtype(), root);
        double[] rectangle = annotationAdapter.getRectangle();
        CreateNodeHelper.addBoxFeature("rectangle", rectangle, root);
        CreateNodeHelper.addWidthHeightFeatures(rectangle, root);
        CreateNodeHelper.addNotEmptyNode(CONTENTS, annotationAdapter.getContents(), root);
        CreateNodeHelper.addNotEmptyNode(ANNOTATION_NAME, annotationAdapter.getAnnotationName(), root);
        CreateNodeHelper.addNotEmptyNode(MODIFIED_DATE, annotationAdapter.getModifiedDate(), root);
        Set<String> formXObjects = annotationAdapter.getFormXObjectsResources();
        if (formXObjects != null && !formXObjects.isEmpty()) {
            FeatureTreeNode resources = root.addChild("resources");
            for (String xObjID : formXObjects) {
                if (xObjID == null) continue;
                FeatureTreeNode xObjNode = resources.addChild("xobject");
                xObjNode.setAttribute("id", xObjID);
            }
        }
        if ((popupId = annotationAdapter.getPopupId()) != null) {
            FeatureTreeNode popup = root.addChild("popup");
            popup.setAttribute("id", popupId);
        }
        CreateNodeHelper.addDeviceColorSpaceNode("color", annotationAdapter.getColor(), root, this);
        CreateNodeHelper.addNotEmptyNode(INVISIBLE, String.valueOf(annotationAdapter.isInvisible()), root);
        CreateNodeHelper.addNotEmptyNode(HIDDEN, String.valueOf(annotationAdapter.isHidden()), root);
        CreateNodeHelper.addNotEmptyNode(PRINT, String.valueOf(annotationAdapter.isPrinted()), root);
        CreateNodeHelper.addNotEmptyNode(NO_ZOOM, String.valueOf(annotationAdapter.isNoZoom()), root);
        CreateNodeHelper.addNotEmptyNode(NO_ROTATE, String.valueOf(annotationAdapter.isNoRotate()), root);
        CreateNodeHelper.addNotEmptyNode(NO_VIEW, String.valueOf(annotationAdapter.isNoView()), root);
        CreateNodeHelper.addNotEmptyNode(READ_ONLY, String.valueOf(annotationAdapter.isReadOnly()), root);
        CreateNodeHelper.addNotEmptyNode(LOCKED, String.valueOf(annotationAdapter.isLocked()), root);
        CreateNodeHelper.addNotEmptyNode(TOGGLE_NO_VIEW, String.valueOf(annotationAdapter.isToggleNoView()), root);
        CreateNodeHelper.addNotEmptyNode(LOCKED_CONTENTS, String.valueOf(annotationAdapter.isLockedContents()), root);
        return root;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Subtype", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, SUB_TYPE), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Width", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, "width"), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Height", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, "height"), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Contents", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, CONTENTS), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Annotation Name", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, ANNOTATION_NAME), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Modified Date", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, MODIFIED_DATE), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Invisible", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, INVISIBLE), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Hidden", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, HIDDEN), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Print", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, PRINT), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("No Zoom", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, NO_ZOOM), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("No Rotate", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, NO_ROTATE), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("No View", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, NO_VIEW), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Read Only", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, READ_ONLY), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Locked", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, LOCKED), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Toggle No View", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, TOGGLE_NO_VIEW), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Locked Contents", AnnotationFeaturesObject.generateVariableXPath(ANNOTATION, LOCKED_CONTENTS), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Error IDs", AnnotationFeaturesObject.generateAttributeXPath(ANNOTATION, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

