/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.axl;

import java.util.HashSet;
import java.util.Set;
import org.verapdf.model.impl.axl.AXLExtensionSchemaObject;
import org.verapdf.model.tools.xmp.ValidatorsContainer;
import org.verapdf.model.tools.xmp.validators.SimpleTypeValidator;
import org.verapdf.model.xmplayer.ExtensionSchemaProperty;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.xmp.impl.VeraPDFXMPNode;

public class AXLExtensionSchemaProperty
extends AXLExtensionSchemaObject
implements ExtensionSchemaProperty {
    public static final String EXTENSION_SCHEMA_PROPERTY = "ExtensionSchemaProperty";
    private static final String CATEGORY = "category";
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String VALUE_TYPE = "valueType";
    private static final Set<String> validChildNames = new HashSet<String>();

    public AXLExtensionSchemaProperty(VeraPDFXMPNode xmpNode, ValidatorsContainer containerForPDFA_1, ValidatorsContainer containerForPDFA_2_3, PDFAFlavour flavour) {
        super(EXTENSION_SCHEMA_PROPERTY, xmpNode, containerForPDFA_1, containerForPDFA_2_3, flavour);
    }

    public String getcategory() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/property#".equals(child.getNamespaceURI()) || !CATEGORY.equals(child.getName())) continue;
            return child.getValue();
        }
        return null;
    }

    public Boolean getisCategoryValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/property#".equals(child.getNamespaceURI()) || !CATEGORY.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    public Boolean getisDescriptionValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/property#".equals(child.getNamespaceURI()) || !DESCRIPTION.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    public Boolean getisNameValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/property#".equals(child.getNamespaceURI()) || !NAME.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    public Boolean getisValueTypeValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/property#".equals(child.getNamespaceURI()) || !VALUE_TYPE.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    public Boolean getisValueTypeDefined() {
        if (this.flavour != null && this.flavour.getPart() == PDFAFlavour.Specification.ISO_19005_1) {
            return this.isValueTypeValidForPDFA_1();
        }
        return this.isValueTypeValidForPDFA_2_3();
    }

    private Boolean isValueTypeValidForPDFA_1() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/property#".equals(child.getNamespaceURI()) || !VALUE_TYPE.equals(child.getName())) continue;
            return this.containerForPDFA_1.isKnownType(child.getValue());
        }
        return Boolean.TRUE;
    }

    private Boolean isValueTypeValidForPDFA_2_3() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/property#".equals(child.getNamespaceURI()) || !VALUE_TYPE.equals(child.getName())) continue;
            return this.containerForPDFA_2_3.isKnownType(child.getValue());
        }
        return Boolean.TRUE;
    }

    public String getcategoryPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/property#".equals(child.getNamespaceURI()) || !CATEGORY.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    public String getdescriptionPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/property#".equals(child.getNamespaceURI()) || !DESCRIPTION.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    public String getnamePrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/property#".equals(child.getNamespaceURI()) || !NAME.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    public String getvalueTypePrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/property#".equals(child.getNamespaceURI()) || !VALUE_TYPE.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    @Override
    protected String getValidNamespaceURI() {
        return "http://www.aiim.org/pdfa/ns/property#";
    }

    @Override
    protected Set<String> getValidChildNames() {
        return validChildNames;
    }

    static {
        validChildNames.add(CATEGORY);
        validChildNames.add(DESCRIPTION);
        validChildNames.add(NAME);
        validChildNames.add(VALUE_TYPE);
    }
}

