/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.parsers.pkcs7;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.util.Arrays;
import org.verapdf.pdfa.parsers.pkcs7.DEREncodedInputStream;
import org.verapdf.pdfa.parsers.pkcs7.DEREncodedValue;

public class X509CertificateImpl {
    private int version = 0;

    public X509CertificateImpl(DEREncodedValue value) throws CertificateException {
        try {
            this.parse(value);
        }
        catch (IOException e) {
            throw new CertificateException("Error while initializing certificate. ", e);
        }
    }

    public int getVersion() {
        return this.version;
    }

    private void parse(DEREncodedValue val) throws CertificateException, IOException {
        byte[] algID;
        DEREncodedValue[] sequence;
        if (val.in != null && val.valueTag == 48) {
            sequence = new DEREncodedValue[3];
            for (int i = 0; i < 3; ++i) {
                sequence[i] = val.in.getDEREncodedValue();
            }
            if (val.in.available() != 0) {
                throw new CertificateParsingException("Extra signed data available = " + val.in.available() + " bytes");
            }
            algID = this.parseAlgId(sequence[1]);
            if (sequence[1].in.available() != 0) {
                throw new CertificateParsingException("Algorithm ID field contains extra data");
            }
            sequence[2].getBitString();
            if (sequence[2].in.available() != 0) {
                throw new CertificateParsingException("Signed fields contain extra data");
            }
            if (sequence[0].valueTag != 48) {
                throw new CertificateParsingException("Invalid certificate signed fields");
            }
        } else {
            throw new CertificateParsingException("Invalid DER-encoded certificate data");
        }
        this.parseCertificateInfo(sequence[0].in, algID);
    }

    private byte[] parseAlgId(DEREncodedValue val) throws IOException {
        if (val.valueTag == 48) {
            DEREncodedValue params;
            DEREncodedInputStream in = val.toDEREncodedInputStream();
            byte[] algId = in.getOID();
            DEREncodedValue dEREncodedValue = params = in.available() == 0 ? null : in.getDEREncodedValue();
            if (params != null && params.valueTag == 5 && !params.areEmpty()) {
                throw new IOException("Invalid null tag");
            }
            if (in.available() != 0) {
                throw new IOException("Algorithm ID contains extra data");
            }
            return algId;
        }
        throw new IOException("Tag is not a sequence");
    }

    private void parseCertificateInfo(DEREncodedInputStream in, byte[] algID) throws IOException, CertificateException {
        this.parseVersionAndSerialNumber(in);
        if (!Arrays.equals(algID, this.parseAlgId(in.getDEREncodedValue()))) {
            throw new CertificateException("Signature algorithms mismatch");
        }
        DEREncodedValue[] nameSeq = this.parseX500Name(in);
        this.validateX500Name(nameSeq, "Empty issuer DN isn't allowed in X509Certificates");
        this.parseValidity(in);
        nameSeq = this.parseX500Name(in);
        if (this.version == 0) {
            this.validateX500Name(nameSeq, "Empty subject DN isn't allowed in V1 X509Certificates");
        }
        DEREncodedValue val = in.getDEREncodedValue();
        if (val.valueTag != 48) {
            throw new IOException("Subject key is corrupted");
        }
        this.parseAlgId(val.in.getDEREncodedValue());
        if (in.available() != 0) {
            if (this.version == 0) {
                throw new CertificateParsingException("V1 X509Certificate contains extra data");
            }
            this.parseExtraData(in);
        }
    }

    private void parseVersionAndSerialNumber(DEREncodedInputStream in) throws IOException {
        DEREncodedValue tmp = in.getDEREncodedValue();
        if (tmp.isContextSpecific((byte)0)) {
            if (tmp.isConstructed()) {
                tmp = tmp.in.getDEREncodedValue();
                BigInteger result = tmp.getBigInteger();
                if (result.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                    throw new IOException("Integer greater than maximum valid value");
                }
                if (result.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
                    throw new IOException("Integer less than minimum valid value");
                }
                this.version = result.intValue();
                if (tmp.in.available() != 0) {
                    throw new IOException("X509Certificate version has bad format");
                }
            }
            tmp = in.getDEREncodedValue();
        }
        tmp.getBigInteger();
        if (tmp.in.available() != 0) {
            throw new IOException("Serial number contains extra data");
        }
    }

    private DEREncodedValue[] parseX500Name(DEREncodedInputStream in) throws IOException {
        DEREncodedValue[] values;
        byte[] bytes = in.inputBuffer.toByteArray();
        try {
            values = in.getSequence(5);
        }
        catch (IOException e) {
            if (bytes == null) {
                values = null;
            }
            bytes = new DEREncodedValue(48, bytes).toByteArray();
            values = new DEREncodedInputStream(bytes).getSequence(5);
        }
        return values;
    }

    private void validateX500Name(DEREncodedValue[] names, String message) throws IOException, CertificateParsingException {
        if (names != null) {
            for (DEREncodedValue value : names) {
                if (value.valueTag != 49) {
                    throw new IOException("Invalid set tag in X500 name");
                }
                if (new DEREncodedInputStream(value.toByteArray()).getSet(5).length != 0) continue;
                throw new CertificateParsingException(message);
            }
        }
    }

    private void parseValidity(DEREncodedInputStream in) throws IOException {
        DEREncodedValue derVal = in.getDEREncodedValue();
        if (derVal.valueTag != 48) {
            throw new IOException("Invalid starting sequence tag");
        }
        if (derVal.in.available() == 0) {
            throw new IOException("Certificate validity contains no data");
        }
        DEREncodedValue[] sequence = new DEREncodedInputStream(derVal.toByteArray()).getSequence(2);
        if (sequence.length != 2 || sequence[0].valueTag != 23 && sequence[0].valueTag != 24 || sequence[1].valueTag != 23 && sequence[1].valueTag != 24) {
            throw new IOException("Error while parsing certificate validity");
        }
    }

    private void parseExtraData(DEREncodedInputStream in) throws CertificateParsingException, IOException {
        DEREncodedValue tmp = in.getDEREncodedValue();
        if (tmp.isContextSpecific((byte)1)) {
            if (in.available() == 0) {
                return;
            }
            tmp = in.getDEREncodedValue();
        }
        if (tmp.isContextSpecific((byte)2)) {
            if (in.available() == 0) {
                return;
            }
            in.getDEREncodedValue();
        }
        if (this.version != 2) {
            throw new CertificateParsingException("Extensions not allowed in v2 certificate");
        }
    }
}

