/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.BaseValidator;
import org.verapdf.pdfa.validation.validators.FastFailValidator;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;

public class ValidatorBuilder {
    private ValidationProfile profile = null;
    private int maxNumberOfDisplayedFailedChecks = 100;
    private boolean logPassedChecks = false;
    private boolean showErrorMessages = true;
    private boolean showProgress = false;
    private int maxFails = -1;

    public ValidatorBuilder config(ValidatorConfig config) {
        return this.maxFails(config.getMaxFails()).logPassedChecks(config.isRecordPasses()).maxNumberOfDisplayedFailedChecks(config.getMaxNumberOfDisplayedFailedChecks()).showErrorMessages(config.showErrorMessages()).showProgress(config.getShowProgress());
    }

    public ValidatorBuilder profile(ValidationProfile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("Parameter (ValidationProfile profile) cannot be null.");
        }
        this.profile = profile;
        return this;
    }

    public ValidatorBuilder flavour(PDFAFlavour flavour) {
        if (flavour == null) {
            throw new IllegalArgumentException("Parameter (PDFAFlavour flavour) cannot be null.");
        }
        this.profile = Profiles.getVeraProfileDirectory().getValidationProfileByFlavour(flavour);
        return this;
    }

    public ValidatorBuilder maxNumberOfDisplayedFailedChecks(int maxNumberOfDisplayedFailedChecks) {
        this.maxNumberOfDisplayedFailedChecks = maxNumberOfDisplayedFailedChecks;
        return this;
    }

    public ValidatorBuilder logPassedChecks(boolean logPassedChecks) {
        this.logPassedChecks = logPassedChecks;
        return this;
    }

    public ValidatorBuilder showErrorMessages(boolean showErrorMessages) {
        this.showErrorMessages = showErrorMessages;
        return this;
    }

    public ValidatorBuilder showProgress(boolean showProgress) {
        this.showProgress = showProgress;
        return this;
    }

    public ValidatorBuilder maxFails(int maxFails) {
        this.maxFails = maxFails;
        return this;
    }

    public static ValidatorBuilder defaultBuilder() {
        return new ValidatorBuilder();
    }

    public PDFAValidator build() {
        if (this.maxFails > 0) {
            return new FastFailValidator(this.profile, this.logPassedChecks, this.maxFails, this.showErrorMessages, this.showProgress, this.maxNumberOfDisplayedFailedChecks);
        }
        return new BaseValidator(this.profile, this.maxNumberOfDisplayedFailedChecks, this.logPassedChecks, this.showErrorMessages, this.showProgress);
    }
}

