/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import org.verapdf.component.AuditDuration;
import org.verapdf.core.VeraPDFException;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.TaskType;
import org.verapdf.report.FeaturesReport;

public abstract class AbstractBatchHandler
implements BatchProcessingHandler {
    public static final String VALIDATION_RESULT = "validationResult";
    public static final String FEATURES_REPORT = "featuresReport";
    public static final String FIXER_REPORT = "fixerReport";
    public static final String FIXER_RESULT = "fixerResult";
    public static final String REPORT = "report";
    public static final String JOB = "job";
    public static final String JOBS = "jobs";
    public static final String PROCESSING_TIME = "processingTime";
    public static final String BUILD_INFORMATION = "buildInformation";
    public static final String ITEM_DETAILS = "itemDetails";
    public static final String RELEASE_DETAILS = "releaseDetails";
    public static final String TASK_EXCEPTION = "taskException";
    public static final String BATCH_SUMMARY = "batchSummary";
    public static final String LOGS = "logs";

    protected AbstractBatchHandler() {
    }

    @Override
    public void handleResult(ProcessorResult result, Boolean isLogsEnabled) throws VeraPDFException {
        if (result == null) {
            throw new VeraPDFException("Arg result is null and can not be handled.");
        }
        this.resultStart(result);
        this.processTasks(result);
        this.resultEnd(result, isLogsEnabled);
    }

    private void processTasks(ProcessorResult result) throws VeraPDFException {
        for (TaskType taskType : result.getTaskTypes()) {
            TaskResult taskResult = result.getResultForTask(taskType);
            if (!taskResult.isExecuted()) continue;
            switch (taskType) {
                case VALIDATE: {
                    if (taskResult.isSuccess()) {
                        this.validationSuccess(taskResult, result.getValidationResult());
                        break;
                    }
                    this.validationFailure(taskResult);
                    break;
                }
                case PARSE: {
                    if (taskResult.isSuccess()) {
                        this.parsingSuccess(taskResult);
                        break;
                    }
                    if (!result.isPdf()) {
                        this.parsingFailure(taskResult);
                        break;
                    }
                    this.pdfEncrypted(taskResult);
                    break;
                }
                case EXTRACT_FEATURES: {
                    if (taskResult.isSuccess()) {
                        this.featureSuccess(taskResult, result.getFeaturesReport());
                        break;
                    }
                    this.featureFailure(taskResult);
                    break;
                }
                case FIX_METADATA: {
                    if (taskResult.isSuccess()) {
                        this.fixerSuccess(taskResult, result.getFixerResult());
                        break;
                    }
                    this.fixerFailure(taskResult);
                    break;
                }
            }
        }
    }

    abstract void resultStart(ProcessorResult var1) throws VeraPDFException;

    abstract void parsingSuccess(TaskResult var1) throws VeraPDFException;

    abstract void parsingFailure(TaskResult var1) throws VeraPDFException;

    abstract void pdfEncrypted(TaskResult var1) throws VeraPDFException;

    abstract void validationSuccess(TaskResult var1, ValidationResult var2) throws VeraPDFException;

    abstract void validationFailure(TaskResult var1) throws VeraPDFException;

    abstract void featureSuccess(TaskResult var1, FeaturesReport var2) throws VeraPDFException;

    abstract void featureFailure(TaskResult var1) throws VeraPDFException;

    abstract void fixerSuccess(TaskResult var1, MetadataFixerResult var2) throws VeraPDFException;

    abstract void fixerFailure(TaskResult var1) throws VeraPDFException;

    abstract void resultEnd(ProcessorResult var1, Boolean var2) throws VeraPDFException;

    public static Collection<AuditDuration> getDurations(ProcessorResult result) {
        EnumMap<TaskType, TaskResult> results = result.getResults();
        if (results != null) {
            ArrayList<AuditDuration> res = new ArrayList<AuditDuration>();
            for (TaskResult taskResult : results.values()) {
                if (taskResult.getDuration() == null) continue;
                res.add(taskResult.getDuration());
            }
            return res;
        }
        return Collections.emptyList();
    }
}

