package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.validaattorit;

import fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.xml.XmlValidatorHelper;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

/**
 * Validaattori xml:n sisältöä varten. Tarkastaa, että xml-parserointi onnistuu voimassaolevien sääntöjen mukaisesti.
 */
public class WellFormedXmlValidator implements ConstraintValidator<WellFormedXmlConstraint, String> {

    @Override
    public void initialize(WellFormedXmlConstraint xmlMessage) {
    }


    @Override
    public boolean isValid(String xmlMessage, ConstraintValidatorContext cxt) {
	
	return xmlMessage!= null && XmlValidatorHelper.isValidiXml(xmlMessage);

    }

}
