package fi.kela.kanta.ptayhteiset.repositorio.transaktio;

/**
 * Luokka tallennuksen tuloksille.
 */
public class TallennusTulos {

    private boolean idKanta;
    private String documentumObjectId;
    private Boolean koostekantaMuutoksia = Boolean.FALSE;


    /**
     * Palauttaa tiedon onko tallennus IDKantaan tehty.
     * 
     * @return true jos IDKanta tallennus on tehty, muuten false.
     */
    public boolean isIdKanta() {
	return idKanta;
    }


    /**
     * Onko tallennus IDKantaan tehty tiedon asetus.
     * 
     * @param idKanta onko tallennus IDKantaan tehty
     */
    public void setIdKanta(boolean idKanta) {
	this.idKanta = idKanta;
    }


    /**
     * Palauttaa Documentumin objektin tunnisteen.
     * 
     * @return Documentumin objektin tunniste
     */
    public String getDocumentumObjectId() {
	return documentumObjectId;
    }


    /**
     * Documentumin objektin tunnisteen asetus.
     * 
     * @param documentumObjectId Documentumin objektin tunniste
     */
    public void setDocumentumObjectId(String documentumObjectId) {
	this.documentumObjectId = documentumObjectId;
    }


    /**
     * Palauttaa tiedon koostekannan tallennuksesta.
     * 
     * @return koostekannan tallennustieto
     */
    public Boolean getKoostekantaMuutoksia() {
	return koostekantaMuutoksia;
    }


    /**
     * Koostekannan tallennustiedon asetus.
     * 
     * @param koostekantaMuutoksia koostekannan tallennustieto
     */
    public void setKoostekantaMuutoksia(Boolean koostekantaMuutoksia) {
	this.koostekantaMuutoksia = koostekantaMuutoksia;
    }


    /*
     * (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
	return "TallennusTulos [idKanta=" + idKanta + ", documentumObjectId=" + documentumObjectId + ", koostekantaMuutoksia=" + koostekantaMuutoksia + "]";
    }

}
