package fi.kela.kanta.ptayhteiset.tietomalli.arvojoukot;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * Enumeraatio palvelupyyntötyypin arvoille.
 */
public enum Palvelupyynto {
    // @formatter:off
    // PPA
    POTILASASIAKIRJOJEN_ARKISTOINTI_PPA ("PPA"),
    POTILASASIAKIRJOJEN_ARKISTOINTI_TOIM_PAAT_PPA11("PPA11"), 
    // PPB
    POTILASASIAKIRJOJEN_HAKU_PPB ("PPB"),
    ARKISTONHOITAJAN_KL_HAKU_PPB01("PPB01"),
    /** arkistonhoitajan haku oman rekisterin asiakirjoihin */
    ARKISTONHOITAJAN_KL_HAKU_PPB02("PPB02"),
    KUVA_AINEISTOJEN_HAKU_PPB03("PPB03"),
    POTILASASIAKIRJOJEN_HAKU_EDUSTAPALVELU_PPB04("PPB04"),  
    ARKISTONHOITAJAN_KL_HAKU_TOIM_PAAT_PPB05("PPB05"),  
    POTILASASIAKIRJOJEN_HAKU_TOIM_PAAT_PPB11("PPB11"), 
    // PPC
    KESKEISTEN_TIETOJEN_HAKU_PPC ("PPC"),   
    KESKEISTEN_TIETOJEN_HAKU_OMAKANTA_PPC01 ("PPC01"),   
    YHTEENVEDON_TIETOJEN_HAKU_ULKOMAILLE_KIELLOT_HUOMIOIDEN_PPC02A ("PPC02A"), 
    YHTEENVEDON_TIETOJEN_HAKU_ULKOMAILLE_KIELLOT_OHITTAEN_PPC02B ("PPC02B"), 
    YHTEENVEDON_TIETOJEN_HAKU_KANSALLINEN_PPC03 ("PPC03"),
    YHTEENVEDON_TIETOJEN_HAKU_OMAKANTA_PPC04 ("PPC04"),
    // vanhat
    PALVELUNANTAJAN_OMIEN_ASIAKIRJOJEN_ARKISTOINTI ("PP1"),
    HAKU_JARJESTAJAN_REKISTERISTA_POTILAS_OSTOPALVELU("PP12"),
    HAKU_JARJESTAJAN_REKISTERISTA_VAESTO_OSTOPALVELU("PP15"),
    ARKISTOINTI_JARJESTAJAN_REKISTERIIN_POTILAS_OSTOPALVELU("PP13"),
    ARKISTOINTI_JARJESTAJAN_REKISTERIIN_VAESTO_OSTOPALVELU("PP16"),
    HAKU_KANSALAINEN("PP19"),
    PALVELUNANTAJAN_OMIEN_TIETOJEN_HAKU("PP2"),
    TALLENNUS_KELA_REKISTERI_KANSALAINEN("PP20"),
    LUOVUTUSHAKU("PP21"),
    HAKU_YHTEISESTA_POTILASREKISTERISTA("PP22"),
    TALLENNUS_KELA_REKISTERI("PP23"),
    SUOSTUMUSASIAKIRJOJEN_HAKU_KELAN_REKISTERISTA("PP24"),
    ARKISTON_HALLINTAKAYTTOLIITTYMA_HAKU_PP2401("PP2401"), 
    SUOSTUMUSASIAKIRJOJEN_JARJESTELMAHAKU_KELAN_REKISTERISTA("PP25"),
    HAKU_EHEALTH_YHTEYSPISTE_PP2501("PP2501"),
    MUIDEN_TAHDONILMAISUJENHAKU_KELAN_REKISTERISTA("PP26"),
    KESKEISTEN_TIETOJEN_HAKU("PP27"),
    KESKEISTEN_TIETOJEN_HATAHAKU("PP28"),
    OMIEN_TIETOJEN_KATSELUN_HAKU_TIEDONHALLINTAPALVELU("PP29"),
    ENNAKKOHAKU("PP30"),
    KESKEISTEN_TIETOJEN_HAKU_KANSALAISELLE("PP31"),
    ARKISTOASIAKIRJOJEN_ARKISTOINTI("PP32"),
    ARKISTOIDUN_ASIAKIRJAN_EDELLEENVALITYS("PP35"),
    VANHOJEN_TIETOJEN_HAKU("PP36"),
    ARKISTON_HALLINTAKAYTTOLIITTYMA_VANHOJEN_TIETOJEN_HAKU_PP3601("PP3601"),    
    ARKISTONHOITAJAN_KL_VANHOJEN_TIETOJEN_HAKU_PP3602("PP3602"),
    TOIMINTANSA_PAATTANEIDEN_VANHOJEN_TIETOJEN_HAKU_PP3611("PP3611"),
    VANHOJEN_TIETOJEN_ARKISTOINTI("PP37"),
    TOIMINTANSA_PAATTANEIDEN_VANHOJEN_TIETOJEN_ARKISTOINTI("PP3711"),
    ASIAKIRJAN_MITATOINTI_KL("PP60"), 
    JARJESTAJAN_OSTOPALVELUNVALTUUTUSTEN_HAKU("PP38"), 
    TUOTTAJAN_OSTOPALVELUNVALTUUTUSTEN_HAKU("PP39"),
    ARKISTON_HALLINTAKAYTTOLIITTYMA_HAKU_PP3801("PP3801"),    
    ARKISTONHOITAJAN_KL_HAKU_PP3802("PP3802"),     
    LUOVUTUSHAKU_POTILAS_OSTOPALVELU("PP40"),
    KESKEISTEN_TIETOJEN_HAKU_POTILAS_OSTOPALVELU("PP41"),
    HATAHAKU_POTILAS_OSTOPALVELU("PP42"),
    KESKEISTEN_TIETOJEN_HATAHAKU_POTILAS_OSTOPALVELU("PP43"),
    LUOVUTUSHAKU_VAESTO_OSTOPALVELU("PP44"),
    KESKEISTEN_TIETOJEN_HAKU_VAESTO_OSTOPALVELU("PP45"),
    HATAHAKU_VAESTO_OSTOPALVELU("PP46"),
    KESKEISTEN_TIETOJEN_HATAHAKU_VAESTO_OSTOPALVELU("PP47"),
    TAHDONILMAISUJEN_HAKU_KELAN_REKISTERISTA_POTILAS_OSTOPALVELU("PP48"),
    TAHDONILMAISUJEN_HAKU_KELAN_REKISTERISTA_VAESTO_OSTOPALVELU("PP49"),
    LUOVUTUSLUPAPYYNTO("PP51"),
    LUOVUTUSTIETOJENKYSELY_AMMATTIHENKILO("PP52"),
    LUOVUTUSTIETOJENKYSELY_JARJESTELMA("PP53"),
    AKTIIVISTEN_PAVLELUTAPAHTUMIEN_HAKU_OMAKAYTTO("PP54"),
    AKTIIVISTEN_PAVLELUTAPAHTUMIEN_HAKU_LUOVUTUS("PP55"),
    AKTIIVISTEN_PAVLELUTAPAHTUMIEN_HAKU_LUOVUTUSKIELTO("PP56"),
    PALVELUTAPAHTUMATARKISTUS("PP57"),
    OSTOPALVELUTARKISTUS("PP58"),
    SUOSTUMUSTENHALLLINNAN_OHITTAVA_HATAHAKU("PP6"),    
    ARKISTONHOITAJAN_KL_HAKU_PP6701("PP6701"),   
    ARKISTON_HALLINTAKAYTTOLIITTYMA_HAKU_PP6702("PP6702");        
    // @formatter:on

    private final String value;

    /**
     * Privaatti konstruktori.
     * 
     * @param value arvo
     */
    private Palvelupyynto(String value) {
        this.value = value;
    }


    /**
     * Palauttaa enumeraation arvon.
     * 
     * @return enumeraation arvo
     */
    public String getValue() {
        return value;
    }


    /**
     * Haetaan palvelunpyyntötyyppi annetun arvon perusteella.
     * 
     * @param value arvo
     * @return Palvelupyynto tai null jos arvoa vastaavaa palvelupyyntöä ei löydy
     */
    @JsonCreator
    private static Palvelupyynto getPalvelupyyntoFromValue(String value) {
        for (Palvelupyynto pp : Palvelupyynto.values()) {
            if (pp.getValue().equals(value)) {
                return pp;
            }
        }
        return null;
    }
}
