package fi.kela.kanta.ptayhteiset.tietomalli.poikkeukset;

import org.slf4j.MDC;

import fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.util.LogUtils;


/**
 * Sovelluksen heittämät omat virheet, jotka peritty RuntimeException luokasta kääritään tähän poikkeusluokkaan
 */
public class AppException extends RuntimeException {

    private static final long serialVersionUID = 9192346992052359091L;

    private final String errorCode;
    private final String logId = MDC.get(LogUtils.CORRELATION_ID);


    /**
     * Luo uuden AppException poikkeuksen.
     * 
     * @param errorCode sisäinen virhekoodi
     */
    public AppException(String errorCode) {
        super();

        this.errorCode = errorCode;

    }


    /**
     * Luo uuden AppException poikkeuksen.
     * 
     * @param message lisätietoa tapahtuneesta poikkeuksesta
     * @param cause alkuperäisen virheen aiheuttama poikkeus
     * @param errorCode sisäinen virhekoodi
     */
    public AppException(String message, Throwable cause, String errorCode) {
        super(message, cause);
        this.errorCode = errorCode;
    }


    /**
     * Luo uuden AppException poikkeuksen.
     * 
     * @param message lisätietoa tapahtuneesta poikkeuksesta
     * @param errorCode sisäinen virhekoodi
     */
    public AppException(String message, String errorCode) {
        super(message);
        this.errorCode = errorCode;
    }


    /**
     * Luo uuden AppException poikkeuksen.
     * 
     * @param cause alkuperäisen virheen aiheuttama poikkeus
     * @param errorCode sisäinen virhekoodi
     */
    public AppException(Throwable cause, String errorCode) {
        super(cause);
        this.errorCode = errorCode;
    }


    /**
     * Sisäisen virhekoodin palautus.
     * 
     * @return sisäinen virhekoodi
     */
    public String getErrorCode() {
        return errorCode;
    }


    /**
     * Yksilöivän lokitunnisteen palautus.
     * 
     * @return yksilöivä lokitunniste
     */
    public String getLogId() {
	return logId;
    }

}
