package fi.kela.kanta.ptayhteiset.jwt;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.util.JWTConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;

/**
 * Dekoodattu JWT-token
 *
 *
 */
public class JWTContentDTO {

    private static final Logger LOG = LoggerFactory.getLogger(JWTContentDTO.class);

    @SerializedName("iss")
    public String iss;
    @SerializedName("aud")
    public String aud;
    @SerializedName("exp")
    public String exp;
    @SerializedName("iat")
    public String iat;
    @SerializedName("jti")
    public String jti;
    @SerializedName("sub")
    public String sub;
    @SerializedName("application_name")
    public String applicationName;
    @SerializedName("application_version")
    public String applicationVersion;
    @SerializedName("subscriber_id")
    public String subscriberId;
    @SerializedName("subscriber_name")
    public String subscriberName;
    @SerializedName("subscriber_unit_id")
    public String subscriberUnitId;
    @SerializedName("subscriber_unit_name")
    public String subscriberUnitName;
    @SerializedName("requester_id")
    public String requesterId;
    @SerializedName("requester_name")
    public String requesterName;
    @SerializedName("requester_unit_id")
    public String requesterUnitId;
    @SerializedName("requester_unit_name")
    public String requesterUnitName;
    @SerializedName("practitioner_id")
    public Map<String,String> practitionerId;
    @SerializedName("practitioner_family")
    public String practitionerFamily;
    @SerializedName("practitioner_given")
    public String[] practitionerGiven;
    @SerializedName("citizen_id")
    public Map<String,String> citizenId;
    @SerializedName("citizen_family")
    public String citizenFamily;
    @SerializedName("citizen_given")
    public String[]citizenGiven;
    @SerializedName("authentication_method")
    public Map<String,String> authenticationMethod;
    @SerializedName("requester_custodian")
    public String requesterCustodian;
    @SerializedName("requester_custodian_name")
    public String requesterCustodianName;
    public Map<String,String> register;
    @SerializedName("register_specifier")
    public Map<String,String> registerSpecifier;
    @SerializedName("requested_record")
    public Map<String,String> requestedRecord;
    @SerializedName("service_event_id")
    public String serviceEventId;
    @SerializedName("special_reason_explanation")
    public String specialReasonExplanation;
    @SerializedName("usage_situation")
    public Map<String, String> usageSituation;
    @SerializedName("special_reason")
    public Map<String,String> specialReason;

    /**
     *
     * @param encodedToken
     * @return
     */
    public static JWTContentDTO decode(String encodedToken) {
        try {
            String[] chunks = encodedToken.split(JWTConstants.JWT_SPLIT_REGEX);

            Base64.Decoder decoder = Base64.getUrlDecoder();
            byte[] decoded = decoder.decode(chunks[1]);
            String decodedString = new String(decoded, StandardCharsets.UTF_8);

            return new Gson().fromJson(decodedString, JWTContentDTO.class);
        } catch (Exception exception) {
            LOG.error("Tokenin parsintavirhe: {}", encodedToken);
            throw new JsonSyntaxException(exception);
        }
    }

    public String toString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(this);
    }
}
