package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.util;

import fi.kela.kanta.ptayhteiset.tietomalli.poikkeukset.InternalServiceError;

/**
 * Luokka lokituksen vakioille ja virhetekstin muotoilulle
 */
public class LogUtils {
    // logging constants
    //
    public static final String CORRELATION_ID = "correlationId";
    public static final String LOG_BEGIN = "BEGIN";
    public static final String LOG_END = "END";
    public static final String LOG_BEGIN_SERVICE = "BEGIN SERVICE";
    public static final String LOG_END_SERVICE = "END SERVICE";

    public static final String LOG_FORMAT_ONE_PARAM_BEGIN = "({}) BEGIN";
    public static final String LOG_FORMAT_ONE_PARAM_END = "({}) END";
    public static final String LOG_FORMAT_ONE_PARAM_BEGIN_SERVICE = "({}) BEGIN SERVICE";
    public static final String LOG_FORMAT_END_SERVICE_MS = "END SERVICE ({} ms)";


    private LogUtils() {
	// yksityinen kontruktori
    }


    // Log format
    //
    /**
     * Muotoilee annetun viestin, jotta se olisi selkeä lukea lokista.
     * 
     * @param error Sisäinen virhe, joka sisältää virheviestin, virhetason sekä virheen kuvauksen
     * @return Muotoillun viestin
     */
    public static String formatMsg(final InternalServiceError error) {
	StringBuilder sb = new StringBuilder();
	if (error != null) {
	    sb.append("Lvl:");
	    sb.append(error.getErrorLevel());
	    sb.append(" Code:");
	    sb.append(error.getErrorCode());
	    sb.append(" Msg:");
	    sb.append(error.getErrorMessage());
	    if (error.getErrorDescription() != null) {
		sb.append(" Desc:");
		sb.append(error.getErrorDescription());
	    }
	} else {
	    sb.append("NULL INTERNAL ERROR!!!");
	}
	return sb.toString();
    }
}
