package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.validaattorit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.util.LogUtils;

public class YTunnusValidator {

    private static final Logger LOG = LoggerFactory.getLogger(YTunnusValidator.class);

    /**
     * Tarkastaa y-tunnuksen oikeellisuuden TP11443.1 mukaisesti.
     * 
     * @param ytunnus ytunnus etunollalla tai ilman. Ei saa sisältää root-osuutta. Tarkastettavat esimerkkisyötteet:
     *        01234567, 1234567, 98765432, 0123456-7. Jos arvo on muuta muotoa, palautetaan automaattisesti false
     * @return true jos validi y-tunnus, false jos ei
     */
    public static boolean validoiYTunnusMuoto(String ytunnus) {
	LOG.debug(LogUtils.LOG_BEGIN);

	if (ytunnus == null || ytunnus.isBlank()) {
	    LOG.error("Y-tunnus virheellinen: null tai blank. ytunnus: {}", ytunnus);
	    LOG.debug(LogUtils.LOG_END);
	    return false;
	}

	int tarkistusmerkki = -1;
	int summa = 0;

	try {
	    tarkistusmerkki = Integer.parseInt(String.valueOf(ytunnus.charAt(ytunnus.length() - 1)));

	    String yTunnusIlmanTarkistusmerkkia;
	    if (ytunnus.charAt(ytunnus.length() - 2) == '-') {
		yTunnusIlmanTarkistusmerkkia = ytunnus.substring(0, ytunnus.length() - 2);
	    } else {
		yTunnusIlmanTarkistusmerkkia = ytunnus.substring(0, ytunnus.length() - 1);
	    }

	    if (yTunnusIlmanTarkistusmerkkia.length() == 6) {
		yTunnusIlmanTarkistusmerkkia = "0" + yTunnusIlmanTarkistusmerkkia;

	    } else if (yTunnusIlmanTarkistusmerkkia.length() != 7) {
		// Jos pituus on jokin muu on tunnus virheellinen
		LOG.error("Y-tunnus virheellinen: väärä pituus. ytunnus: {}", ytunnus);
		LOG.debug(LogUtils.LOG_END);
		return false;
	    }

	    int[] kertoimet = { 7, 9, 10, 5, 8, 4, 2 }; // tarkistusmerkin laskukaavan kertoimet, TP11443.1
	    for (int i = 0; i < kertoimet.length; i++) {

		summa += Integer.parseInt(String.valueOf(yTunnusIlmanTarkistusmerkkia.charAt(i))) * kertoimet[i];
	    }
	} catch (NumberFormatException e) {
	    LOG.error("Y-tunnus virheellinen: NumberFormatException. ytunnus: {}", ytunnus);
	    LOG.debug(LogUtils.LOG_END);
	    return false;
	}

	boolean retVal = false;
	int jaannos = summa % 11;
	
	switch (jaannos) {
	    case 0:
		if (tarkistusmerkki == jaannos) {
		    LOG.debug(LogUtils.LOG_END);
		    retVal = true;
		}
		break;
	    case 1:
		LOG.debug(LogUtils.LOG_END);
		retVal = false;
		break;
	    default:
		if (tarkistusmerkki == 11 - jaannos) {
		    LOG.debug(LogUtils.LOG_END);
		    retVal = true;
		}
		break;

	}
	LOG.debug(LogUtils.LOG_END);
	return retVal;
    }
}
