package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;

/**
 * Luokka HL7-namespace käsittelyyn.
 */
public class HL7NamespaceContext implements NamespaceContext {

    public static final String NAMESPACE_XMLNS_ATTRIBUTE = "xmlns:";
    public static final String NAMESPACE_PREFIX_V3 = "v3";
    public static final String NAMESPACE_URN_HL7_ORG_V3 = "urn:hl7-org:v3";
    public static final String NAMESPACE_PREFIX_HL7FI = "hl7fi";
    public static final String NAMESPACE_URN_HL7FINLAND = "urn:hl7finland";

    private Map<String, String> urisByPrefix = new HashMap<>();


    /**
     * HL7NamespaceContext-luokan konstruktori.
     */
    public HL7NamespaceContext() {
	addNamespace(XMLConstants.XML_NS_PREFIX, XMLConstants.XML_NS_URI);
	addNamespace(XMLConstants.XMLNS_ATTRIBUTE, XMLConstants.XMLNS_ATTRIBUTE_NS_URI);
	addNamespace(NAMESPACE_PREFIX_V3, NAMESPACE_URN_HL7_ORG_V3);
    }


    /**
     * Lisää namespacen prefixmappiin.
     * 
     * @param prefix prefix
     * @param namespaceURI namespaceURI
     */
    private void addNamespace(String prefix, String namespaceURI) {
	urisByPrefix.put(prefix, namespaceURI);
    }


    @Override
    public String getNamespaceURI(String prefix) {
	if (prefix == null) {
	    throw new IllegalArgumentException("prefix cannot be null");
	}
	if (urisByPrefix.containsKey(prefix)) {
	    return urisByPrefix.get(prefix);
	} else {
	    return XMLConstants.NULL_NS_URI;
	}
    }


    @Override
    public String getPrefix(String namespaceURI) {
	throw new UnsupportedOperationException();
    }


    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
	throw new UnsupportedOperationException();
    }
}