package fi.kela.kanta.ptayhteiset.liiketoimintalogiikka.xml;

import java.io.IOException;
import java.io.StringReader;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;




/**
 * Apuluokka XML viestin validointiin.
 */
public class XmlValidatorHelper {

    /**
     * Tarkista onko validi xml-viesti.
     * 
     * @param xmlMessage validoitava xml-viesti
     * @return boolean oliko validi
     */
    public static boolean isValidiXml(String xmlMessage) {
	
	boolean onValidi = true;
	
	try {
	    muodostaDomDokumentti(xmlMessage);
        } catch (ParserConfigurationException | SAXException | IOException e) {
            onValidi = false;
	}
	
	return onValidi; 

    }
    

    
    /**
     * Tarkistaa onko validi xml-viesti ja hakee dom dokumentin.
     * 
     * @param xmlMessage xml-viesti (validointi ja dokumentin perusta)
     * @return Dom dokumentti
     */
    public static Document muodostaJaHaeDomDokumentti(String xmlMessage) throws ParserConfigurationException, SAXException, IOException {
	
	Document document = null;
	
	try {
	    document = muodostaDomDokumentti(xmlMessage);
        } catch (ParserConfigurationException | SAXException | IOException e) {
            throw e;
	}
	
	return document;
    }
    
    
    
	
    /**
     * Palauttaa xml-viestistä muodostetun dom-dokumentin jos se läpäisee DBF-tarkastuksen. Jos suorituksessa
     * tapahtuu virhe, heitetään saatu poikkeus eteenpäin. 
     * 
     * @param xmlMessage validoitava xml-viesti
     * @return viestistä muodostettu dom-dokumentti
     * @throws ParserConfigurationException 
     * @throws IOException 
     * @throws SAXException 
     */
    private static Document muodostaDomDokumentti(String xmlMessage) throws ParserConfigurationException, SAXException, IOException  {

	Document document = null;
	final StringReader xmlReader = new StringReader(xmlMessage);
	
	try (xmlReader) {
 
	    DocumentBuilderFactory factory = haeDocumentBuilderFactory();

	    InputSource inputSource = new InputSource(xmlReader);

	    document = factory.newDocumentBuilder().parse(inputSource);	 

	} catch (ParserConfigurationException | SAXException | IOException e) {
	    throw e;
	}

	return document;

    }
    
    
    /**
     * Haetaan DocumentBuilderFactory-objekti, johon asetettu halutut ominaisuudet. Jos suorituksessa
     * tapahtuu virhe, heitetään ParserConfiguration-poikkeus 
     * 
     * @return DocumentBuilderFactory 
     * @throws ParserConfigurationException 
     */
    private static DocumentBuilderFactory haeDocumentBuilderFactory() throws ParserConfigurationException {

    	 DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    	 
 	 factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
 	 factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
 	 factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
 	 factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
 	 factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
 	 factory.setXIncludeAware(false);
 	 factory.setExpandEntityReferences(false);
 	 factory.setNamespaceAware(true);
 	 factory.setIgnoringComments(false);
    	
         return factory;

    }

    
}
