package fi.kela.kanta.ptayhteiset.tietomalli.arvojoukot;

import java.util.HashMap;
import java.util.Map;

/**
 * Enumeraatio metatietohaun kohdistusarvoille.
 */
public enum MetatietoKohdistus {

    // 1 Metatietoja käsitellään palvelutapahtumatasolla
    // 2 Metatietoja käsitellään asiakirjatasolla
    PALVELUTAPAHTUMATASO("1"), ASIAKIRJATASO("2");

    private final String value;


    /**
     * Privaatti konstruktori.
     * 
     * @param value arvo
     */
    private MetatietoKohdistus(String value) {
	this.value = value;
    }


    /**
     * Palauttaa enumeraation arvon.
     * 
     * @return enumeraation arvo
     */
    public String getValue() {
	return value;
    }

    private static final Map<String, MetatietoKohdistus> lookup = new HashMap<>();

    static {
	for (MetatietoKohdistus metatietoKohdistus : MetatietoKohdistus.values()) {
	    lookup.put(metatietoKohdistus.getValue(), metatietoKohdistus);
	}
    }


    /**
     * Palauttaa enumeraation annetun arvon perusteella.
     * 
     * @param value arvo
     * @return enumeraatio
     */
    public static MetatietoKohdistus get(String value) {
	return lookup.get(value);
    }
}
