package fi.kela.kanta.ptayhteiset.tietomalli.arvojoukot;

/**
 * Enumeraatio rekisteritunnuksen arvoille.
 */
public enum Rekisteritunnus {

    JULKINEN("2"), YKSITYINEN("3"), TYOTERVEYS("4"), KAYTOSTA_POISTETTU("11"), THP_ASIAKIRJAT("12"), ARKISTO_ASIAKIRJAT("13");

    private final String value;


    /**
     * Privaatti konstruktori.
     * 
     * @param value arvo
     */
    private Rekisteritunnus(String value) {
	this.value = value;
    }


    /**
     * Palauttaa enumeraation arvon.
     * 
     * @return enumeraation arvo
     */
    public String getValue() {
	return value;
    }
}
